/*
 * Decompiled with CFR 0.152.
 */
package org.bituf.fountain.jdbc;

import java.lang.reflect.UndeclaredThrowableException;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.interceptor.DefaultTransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.transaction.support.CallbackPreferringPlatformTransactionManager;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomTransactionTemplate
extends TransactionTemplate {
    protected final PlatformTransactionManager transactionManager;
    protected final TransactionAttribute transactionAttribute;

    public CustomTransactionTemplate(PlatformTransactionManager transactionManager) {
        super(transactionManager);
        Assert.notNull((Object)transactionManager, (String)"`transactionManager` must not be null");
        this.transactionManager = transactionManager;
        this.transactionAttribute = new DefaultTransactionAttribute();
    }

    public CustomTransactionTemplate(PlatformTransactionManager transactionManager, TransactionAttribute transactionAttribute) {
        super(transactionManager, (TransactionDefinition)transactionAttribute);
        Assert.notNull((Object)transactionManager, (String)"`transactionManager` must not be null");
        Assert.notNull((Object)transactionAttribute, (String)"`transactionAttribute` must not be null");
        this.transactionManager = transactionManager;
        this.transactionAttribute = transactionAttribute;
    }

    public TransactionAttribute getTransactionAttribute() {
        return this.transactionAttribute;
    }

    public <T> T execute(TransactionCallback<T> action) throws TransactionException {
        Object result;
        if (this.transactionManager instanceof CallbackPreferringPlatformTransactionManager) {
            return (T)((CallbackPreferringPlatformTransactionManager)this.transactionManager).execute((TransactionDefinition)this, action);
        }
        TransactionStatus status = this.transactionManager.getTransaction((TransactionDefinition)this);
        try {
            result = action.doInTransaction(status);
        }
        catch (RuntimeException ex) {
            if (this.transactionAttribute.rollbackOn((Throwable)ex)) {
                this.rollbackOnException(status, ex);
            } else {
                this.transactionManager.commit(status);
            }
            throw ex;
        }
        catch (Error err) {
            if (this.transactionAttribute.rollbackOn((Throwable)err)) {
                this.rollbackOnException(status, err);
            } else {
                this.transactionManager.commit(status);
            }
            throw err;
        }
        catch (Exception ex) {
            if (this.transactionAttribute.rollbackOn((Throwable)ex)) {
                this.rollbackOnException(status, ex);
            } else {
                this.transactionManager.commit(status);
            }
            throw new UndeclaredThrowableException(ex, "TransactionCallback threw undeclared checked exception");
        }
        this.transactionManager.commit(status);
        return (T)result;
    }

    private void rollbackOnException(TransactionStatus status, Throwable ex) throws TransactionException {
        this.logger.debug((Object)"Initiating transaction rollback on application exception", ex);
        try {
            this.transactionManager.rollback(status);
        }
        catch (TransactionSystemException ex2) {
            this.logger.error((Object)"Application exception overridden by rollback exception", ex);
            ex2.initApplicationException(ex);
            throw ex2;
        }
        catch (RuntimeException ex2) {
            this.logger.error((Object)"Application exception overridden by rollback exception", ex);
            throw ex2;
        }
        catch (Error err) {
            this.logger.error((Object)"Application exception overridden by rollback error", ex);
            throw err;
        }
    }
}

