(ns leiningen.new.basilisp
  (:require [leiningen.new.templates :as tmpl]
            [leiningen.core.main :as main]))

(def render (tmpl/renderer "basilisp"))

(defn basilisp
  "Generate a fresh Basilisp project."
  [name]
  (let [core-ns (tmpl/multi-segment (tmpl/sanitize-ns name) "core")
        data    {:raw-name     name
                 :name         (tmpl/project-name name)
                 :namespace    core-ns
                 :project-path (tmpl/name-to-path name)
                 :year         (tmpl/year)}]

    (main/info "Generating fresh 'lein new' Basilisp project.")

    (tmpl/->files data
                  ["src/{{project-path}}/__init__.py" (render "__init__.py" data)]
                  ["src/{{project-path}}/core.lpy" (render "core.lpy" data)]
                  ["tests/{{project-path}}/core_test.lpy" (render "test.lpy" data)]
                  ["basilisp.edn" (render "basilisp.edn" data)]
                  ["pyproject.toml" (render "pyproject.toml" data)]
                  ["LICENSE" (render "LICENSE" data)]
                  ["README.md" (render "README.md" data)]
                  [".gitignore" (render "gitignore" data)])

    (main/info (str "If you are using pip, you can now prepare your virtualenv:\n"
                    "  python -m venv .venv && source .venv/bin/activate && pip install -e ."))
    (main/info (str "From within the virtual environment, you can start a REPL:\n"
                    "  basilisp repl"))
    (main/info (str "Tests can be run from the CLI:\n"
                    "  basilisp test -p tests --include-unsafe-path=false"))
    (main/info (str "To deactivate the virtual environment:\n"
                    "  deactivate"))

    (main/info "\n\n")

    (main/info (str "If you instead prefer to use uv, you can prepare your virtualenv like this:\n"
                    "  uv sync"))
    (main/info (str "You can start a REPL from uv:\n"
                    "  uv run basilisp repl"))
    (main/info (str "Tests can be run from the CLI:\n"
                    "  uv run basilisp test -p tests --include-unsafe-path=false"))))
