(ns leiningen.new.basilisp
  (:require [leiningen.new.templates :as tmpl]
            [leiningen.core.main :as main]))

(def render (tmpl/renderer "basilisp"))

(defn basilisp
  "Generate a fresh Basilisp project."
  [name]
  (let [core-ns (tmpl/multi-segment (tmpl/sanitize-ns name) "core")
        data    {:raw-name     name
                 :name         (tmpl/project-name name)
                 :namespace    core-ns
                 :project-path (tmpl/name-to-path name)}]
    (main/info "Generating fresh 'lein new' Basilisp project.")
    (tmpl/->files data
                  ["src/{{project-path}}/__init__.py" (render "__init__.py" data)]
                  ["src/{{project-path}}/core.lpy" (render "core.lpy" data)]
                  ["tests/{{project-path}}/test_core.lpy" (render "test.lpy" data)]
                  ["pyproject.toml" (render "pyproject.toml" data)])
    (main/info (str "You can now prepare your virtualenv:\n"
                    "  python -m venv .venv && source .venv/bin/activate && pip install -e ."))))
