(ns scratch
  (:require [sci.core]))

;; helper
(defn invoke-ex-fn [f]
  (try
    {:type :ok
     :value (f)}
    (catch Throwable e
      (merge {:type (class e)} (select-keys (ex-data e) [:type :line :column])))))

;; Invoke problematic code from different threads and get a different result
(prn (let [f (sci.core/eval-string "(fn [] (/ 1 0))")]
       [(invoke-ex-fn f)
        @(future (invoke-ex-fn f))
        (invoke-ex-fn f)]))
                                        ;=>
'[{:type :sci/error, :line 1, :column 8} 
  {:type java.lang.ArithmeticException} ;; => result from different thread
  {:type :sci/error, :line 1, :column 8}]

(shutdown-agents)
