(require '[sci.impl.types :as types])

(defn ^:private make-protocol-sci-compatible [proto-var]
  (let [sci-compatible? (-> proto-var meta ::sci-compatible?)]
    (when-not sci-compatible?
      (alter-meta! proto-var
                   assoc
                   ::sci-compatible-protocol true)

      (doseq [method-var (keys (:method-builders @proto-var))]
        (let [old-impl @method-var
              method-name (.sym method-var)
              new-impl (new clojure.lang.MultiFn
                            (name (gensym (name method-name)))
                            types/type-impl
                            :default
                            #'clojure.core/global-hierarchy)]
          (. new-impl
             clojure.core/addMethod
             :sci.impl.protocols/reified
             (fn [this & args]
               (let [method (-> (types/getMethods this)
                                (get method-name))]
                 (apply method this args))))

          (. new-impl
             clojure.core/addMethod
             :default
             (fn [this & args]
               (apply old-impl this args)))

          (alter-meta! method-var
                       assoc ::original-impl old-impl)
          (alter-var-root method-var
                          (constantly new-impl)))))))
