(ns scratch
  (:require [jsonista.core :as json])
  (:refer-clojure :exclude [read]))

(set! *warn-on-reflection* true)

(defn- -key-fn->object-mapper
  ^com.fasterxml.jackson.databind.ObjectMapper [key-fn]
  (if-not key-fn
    json/default-object-mapper
    (json/object-mapper {:decode-key-fn key-fn})))

(defn ->json-reader
  ([reader] (->json-reader reader nil))
  ([reader {:keys [key-fn] :or {key-fn keyword}}]
   (-> (-key-fn->object-mapper key-fn)
       .getFactory
       (.createParser ^java.io.Reader reader))))

(defn read
  ([s] (read s nil))
  ([s _ #_{:keys [key-fn] :or {key-fn keyword}}]
   (.readValueAs ^com.fasterxml.jackson.core.json.ReaderBasedJsonParser s Object)))

(prn
 (= {"a" 1} (read (->json-reader (java.io.StringReader. "{\"a\": 1}") {:key-fn str})
                  nil #_{:key-fn str})))
