(require '[babashka.cli :as cli] :reload)

(cli/parse-opts
 ["--dude" "-h"]
 {:spec {:org  {:desc    "organization_name"
                :ref     "<val>"
                :require true}
         :help {:coerce :boolean :alias :h}}
  :error-fn
  (fn [{:keys [spec type cause msg option] :as data}]
    (prn :data data)
    (if (= :org.babashka/cli type)
      (case cause
        :require
        (println
         (format "Missing required argument:\n%s"
                 (cli/format-opts {:spec (select-keys spec [option])})))
        (println msg))
      (throw (ex-info msg data)))
    #_(System/exit 1))}) ;; => {:help true}
