(require '[babashka.cli :as cli])

(def global-spec {:foo {:coerce :keyword}})
(def sub1-spec {:bar {:coerce :keyword}})
(def sub2-spec {:baz {:coerce :keyword}})

(def table
  [{:cmds [] :spec global-spec}
   {:cmds ["sub1"] :fn identity :spec sub1-spec}
   {:cmds ["sub1" "sub2"] :fn identity :spec sub2-spec}])

(prn (cli/dispatch table ["--foo" "a" "sub1" "--bar" "b" "sub2" "--baz" "c" "arg"]))

(prn (cli/dispatch table ["sub1" "--foo" "bar"]))


(def table
  [{:cmds ["sub1"] :fn identity :spec sub1-spec :args->opts [:some-opt]}
   {:cmds ["sub1" "sub2"] :fn identity :spec sub2-spec}])

(prn (cli/dispatch table ["sub1" "dude"]))
(prn (cli/dispatch table ["sub1" "sub2"]))
;;=>

{:dispatch ["sub1" "sub2"],
 :opts {:foo :a, :bar :b, :baz :c},
 :opts-by-cmds
 [{:cmds [], :opts {:foo :a}}
  {:cmds ["sub1"], :opts {:bar :b}}
  {:cmds ["sub1" "sub2"], :opts {:baz :c}}],
 :args ["arg"]}
