/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.xmlrpc;

import java.io.ByteArrayInputStream;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.SortedSet;
import javax.security.auth.login.LoginException;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.api.WikiPage;
import org.apache.wiki.auth.AuthenticationManager;
import org.apache.wiki.auth.AuthorizationManager;
import org.apache.wiki.auth.WikiSecurityException;
import org.apache.wiki.auth.permissions.PermissionFactory;
import org.apache.wiki.content.PageNotFoundException;
import org.apache.wiki.content.WikiPath;
import org.apache.wiki.content.jcr.JCRWikiPage;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.apache.wiki.plugin.WeblogEntryPlugin;
import org.apache.wiki.plugin.WeblogPlugin;
import org.apache.wiki.providers.ProviderException;
import org.apache.wiki.rpc.WikiRPCHandler;
import org.apache.wiki.ui.stripes.WikiActionBeanContext;
import org.apache.xmlrpc.XmlRpcException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaWeblogHandler
implements WikiRPCHandler {
    private static Logger log = LoggerFactory.getLogger(MetaWeblogHandler.class);
    private WikiContext m_context;
    private static final int ERR_NOTFOUND = 404;
    private static final int ERR_SERVER_ERROR = 500;
    private static final int ERR_UNAUTHORIZED = 401;

    @Override
    public void initialize(WikiContext context) {
        this.m_context = context;
    }

    private void checkPermissions(WikiPage page, String username, String password, String permission) throws XmlRpcException {
        block5: {
            try {
                AuthenticationManager amm = this.m_context.getEngine().getAuthenticationManager();
                AuthorizationManager mgr = this.m_context.getEngine().getAuthorizationManager();
                if (amm.login(this.m_context.getWikiSession(), this.m_context.getHttpRequest(), username, password)) {
                    if (!mgr.checkPermission(this.m_context.getWikiSession(), PermissionFactory.getPagePermission(page, permission))) {
                        throw new XmlRpcException(401, "No permission");
                    }
                    break block5;
                }
                throw new XmlRpcException(401, "Unknown login");
            }
            catch (WikiSecurityException e) {
                throw new XmlRpcException(500, e.getMessage(), (Throwable)e);
            }
            catch (LoginException e) {
                throw new XmlRpcException(500, e.getMessage(), (Throwable)e);
            }
        }
    }

    public Hashtable<String, ? extends Object> getCategories(String blogid, String username, String password) throws XmlRpcException {
        try {
            WikiPage page = this.m_context.getEngine().getPage(blogid);
            this.checkPermissions(page, username, password, "view");
            Hashtable ht = new Hashtable();
            return ht;
        }
        catch (PageNotFoundException e) {
            throw new XmlRpcException(404, "No such page");
        }
        catch (ProviderException e) {
            throw new XmlRpcException(500, "No such page");
        }
    }

    private String getURL(String page) {
        return this.m_context.getEngine().getURL(WikiContext.VIEW, page, null, true);
    }

    private Hashtable<String, ? extends Object> makeEntry(WikiPage page) throws XmlRpcException {
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        try {
            WikiPage firstVersion = this.m_context.getEngine().getPage(page.getName(), 1);
            ht.put("dateCreated", firstVersion.getLastModified());
            ht.put("link", this.getURL(page.getName()));
            ht.put("permaLink", this.getURL(page.getName()));
            ht.put("postid", page.getName());
            ht.put("userid", page.getAuthor());
            String pageText = this.m_context.getEngine().getText(page.getName());
            String title = "";
            int firstLine = pageText.indexOf(10);
            if (firstLine > 0) {
                title = pageText.substring(0, firstLine);
            }
            if (title.trim().length() == 0) {
                title = page.getName();
            }
            while (title.startsWith("!")) {
                title = title.substring(1);
            }
            ht.put("title", title);
            ht.put("description", pageText);
        }
        catch (PageNotFoundException e) {
            throw new XmlRpcException(404, "Not found");
        }
        catch (ProviderException e) {
            throw new XmlRpcException(500, e.getMessage());
        }
        return ht;
    }

    public Hashtable<String, ? extends Object> getRecentPosts(String blogid, String username, String password, int numberOfPosts) throws XmlRpcException {
        Hashtable<String, Hashtable<String, ? extends Object>> result = new Hashtable<String, Hashtable<String, ? extends Object>>();
        log.info("metaWeblog.getRecentPosts() called", new Object[0]);
        try {
            WikiPage page = this.m_context.getEngine().getPage(blogid);
            this.checkPermissions(page, username, password, "view");
            WeblogPlugin plugin = new WeblogPlugin();
            SortedSet<WikiPage> changed = plugin.findBlogEntriesSorted(this.m_context.getEngine().getContentManager(), blogid, new Date(0L), new Date());
            int items = 0;
            Iterator i = changed.iterator();
            while (i.hasNext() && items < numberOfPosts) {
                WikiPage p = (WikiPage)i.next();
                result.put("entry", this.makeEntry(p));
                ++items;
            }
        }
        catch (PageNotFoundException e) {
            throw new XmlRpcException(404, e.getMessage());
        }
        catch (ProviderException e) {
            log.error("Failed to list recent posts", e);
            throw new XmlRpcException(500, e.getMessage());
        }
        return result;
    }

    public String newPost(String blogid, String username, String password, Hashtable<String, ? extends Object> content, boolean publish) throws XmlRpcException {
        log.info("metaWeblog.newPost() called", new Object[0]);
        WikiEngine engine = this.m_context.getEngine();
        try {
            WikiPage page = engine.getPage(blogid);
            this.checkPermissions(page, username, password, "createPages");
            WeblogEntryPlugin plugin = new WeblogEntryPlugin();
            String pageName = plugin.getNewEntryPage(engine, blogid);
            WikiPage entryPage = engine.createPage(WikiPath.valueOf(pageName));
            entryPage.setAuthor(username);
            WikiActionBeanContext context = engine.getWikiContextFactory().newViewContext(entryPage);
            StringBuilder text = new StringBuilder();
            text.append("!" + content.get("title"));
            text.append("\n\n");
            text.append(content.get("description"));
            log.debug("Writing entry: " + text, new Object[0]);
            engine.saveText(context, text.toString());
        }
        catch (PageNotFoundException e) {
            throw new XmlRpcException(404, "Not found");
        }
        catch (Exception e) {
            log.error("Failed to create weblog entry", e);
            throw new XmlRpcException(500, "Failed to create weblog entry: " + e.getMessage());
        }
        return "";
    }

    public Hashtable<String, ? extends Object> newMediaObject(String blogid, String username, String password, Hashtable<String, ? extends Object> content) throws XmlRpcException {
        WikiEngine engine = this.m_context.getEngine();
        String url = "";
        log.info("metaWeblog.newMediaObject() called", new Object[0]);
        try {
            WikiPage page = engine.getPage(blogid);
            this.checkPermissions(page, username, password, "upload");
            String name = (String)content.get("name");
            byte[] data = (byte[])content.get("bits");
            JCRWikiPage att = engine.getContentManager().addPage(WikiPath.valueOf(blogid).resolve(name), "application/octet-stream");
            att.setAuthor(username);
            att.setContent(new ByteArrayInputStream(data));
            engine.getContentManager().save(att);
            url = engine.getURL(WikiContext.ATTACH, att.getName(), null, true);
        }
        catch (PageNotFoundException e) {
            throw new XmlRpcException(404, "Not found");
        }
        catch (Exception e) {
            log.error("Failed to upload attachment", e);
            throw new XmlRpcException(500, "Failed to upload media object: " + e.getMessage());
        }
        Hashtable<String, String> result = new Hashtable<String, String>();
        result.put("url", url);
        return result;
    }

    boolean editPost(String postid, String username, String password, Hashtable<String, ? extends Object> content, boolean publish) throws XmlRpcException {
        WikiEngine engine = this.m_context.getEngine();
        log.info("metaWeblog.editPost(" + postid + ") called", new Object[0]);
        try {
            WikiPage page = engine.getPage(postid);
            this.checkPermissions(page, username, password, "edit");
            WikiPage entryPage = (WikiPage)page.clone();
            entryPage.setAuthor(username);
            WikiActionBeanContext context = engine.getWikiContextFactory().newViewContext(entryPage);
            StringBuilder text = new StringBuilder();
            text.append("!" + content.get("title"));
            text.append("\n\n");
            text.append(content.get("description"));
            log.debug("Updating entry: " + text, new Object[0]);
            engine.saveText(context, text.toString());
        }
        catch (PageNotFoundException e) {
            throw new XmlRpcException(404, "Not found");
        }
        catch (Exception e) {
            log.error("Failed to create weblog entry", e);
            throw new XmlRpcException(500, "Failed to update weblog entry: " + e.getMessage());
        }
        return true;
    }

    Hashtable<String, ? extends Object> getPost(String postid, String username, String password) throws XmlRpcException {
        String wikiname = "FIXME";
        try {
            WikiPage page = this.m_context.getEngine().getPage(wikiname);
            this.checkPermissions(page, username, password, "view");
            return this.makeEntry(page);
        }
        catch (PageNotFoundException e) {
            throw new XmlRpcException(404, "Not found");
        }
        catch (ProviderException e) {
            throw new XmlRpcException(500, e.getMessage());
        }
    }
}

