/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.workflow;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.WikiSession;
import org.apache.wiki.api.WikiException;
import org.apache.wiki.auth.acl.UnresolvedPrincipal;
import org.apache.wiki.event.WikiEvent;
import org.apache.wiki.event.WikiEventListener;
import org.apache.wiki.event.WorkflowEvent;
import org.apache.wiki.workflow.DecisionQueue;
import org.apache.wiki.workflow.Workflow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkflowManager
implements WikiEventListener {
    private final DecisionQueue m_queue = new DecisionQueue();
    private final Set<Workflow> m_workflows = new HashSet<Workflow>();
    private final Map<String, Principal> m_approvers = new HashMap<String, Principal>();
    private final List<Workflow> m_completed = new ArrayList<Workflow>();
    protected static final String PROPERTY_APPROVER_PREFIX = "jspwiki.approver.";
    private WikiEngine m_engine = null;
    private volatile int m_next = 1;

    public void start(Workflow workflow) throws WikiException {
        this.m_workflows.add(workflow);
        workflow.setWorkflowManager(this);
        workflow.setId(this.nextId());
        workflow.start();
    }

    public Collection<Workflow> getWorkflows() {
        return new HashSet<Workflow>(this.m_workflows);
    }

    public List<Workflow> getCompletedWorkflows() {
        return new ArrayList<Workflow>(this.m_completed);
    }

    public void initialize(WikiEngine engine, Properties props) {
        this.m_engine = engine;
        for (String string : props.keySet()) {
            String approver;
            String key;
            if (!string.startsWith(PROPERTY_APPROVER_PREFIX) || (key = string.substring(PROPERTY_APPROVER_PREFIX.length())) == null || key.length() <= 0 || (approver = props.getProperty(string)) == null || approver.length() <= 0) continue;
            this.m_approvers.put(key, new UnresolvedPrincipal(approver));
        }
    }

    public boolean requiresApproval(String messageKey) {
        return this.m_approvers.containsKey(messageKey);
    }

    public Principal getApprover(String messageKey) throws WikiException {
        Principal approver = this.m_approvers.get(messageKey);
        if (approver == null) {
            throw new WikiException("Workflow '" + messageKey + "' does not require approval.");
        }
        if (approver instanceof UnresolvedPrincipal) {
            String name = approver.getName();
            approver = this.m_engine.getAuthorizationManager().resolvePrincipal(name);
            if (approver instanceof UnresolvedPrincipal) {
                throw new WikiException("Workflow approver '" + name + "' cannot not be resolved.");
            }
            this.m_approvers.put(messageKey, approver);
        }
        return approver;
    }

    public WikiEngine getEngine() {
        if (this.m_engine == null) {
            throw new IllegalStateException("WikiEngine cannot be null; please initialize WorkflowManager first.");
        }
        return this.m_engine;
    }

    public DecisionQueue getDecisionQueue() {
        return this.m_queue;
    }

    private synchronized int nextId() {
        int current = this.m_next++;
        return current;
    }

    public List<Workflow> getOwnerWorkflows(WikiSession session) {
        ArrayList<Workflow> workflows = new ArrayList<Workflow>();
        if (session.isAuthenticated()) {
            Principal[] sessionPrincipals = session.getPrincipals();
            block0: for (Workflow w : this.m_workflows) {
                Principal owner = w.getOwner();
                Principal[] principalArray = sessionPrincipals;
                int n = sessionPrincipals.length;
                int n2 = 0;
                while (n2 < n) {
                    Principal sessionPrincipal = principalArray[n2];
                    if (sessionPrincipal.equals(owner)) {
                        workflows.add(w);
                        continue block0;
                    }
                    ++n2;
                }
            }
        }
        return workflows;
    }

    @Override
    public void actionPerformed(WikiEvent event) {
        if (event instanceof WorkflowEvent) {
            Workflow workflow = (Workflow)event.getSource();
            switch (event.getType()) {
                case 50: {
                    this.remove(workflow);
                    break;
                }
                case 40: {
                    this.remove(workflow);
                    break;
                }
                case 0: {
                    this.add(workflow);
                    break;
                }
            }
        }
    }

    protected synchronized void add(Workflow workflow) {
        if (workflow.getWorkflowManager() == null) {
            workflow.setWorkflowManager(this);
        }
        if (workflow.getId() == 0) {
            workflow.setId(this.nextId());
        }
        this.m_workflows.add(workflow);
    }

    protected synchronized void remove(Workflow workflow) {
        if (this.m_workflows.contains(workflow)) {
            this.m_workflows.remove(workflow);
            this.m_completed.add(workflow);
        }
    }
}

