/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.workflow;

import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.wiki.WikiSession;
import org.apache.wiki.api.WikiException;
import org.apache.wiki.workflow.Decision;
import org.apache.wiki.workflow.Outcome;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecisionQueue
implements Serializable {
    private static final long serialVersionUID = -7172912793410302533L;
    private LinkedList<Decision> m_queue = new LinkedList();
    private volatile int m_next = 1000;

    protected synchronized void add(Decision decision) {
        this.m_queue.addLast(decision);
        decision.setId(this.nextId());
    }

    protected Decision[] decisions() {
        return this.m_queue.toArray(new Decision[this.m_queue.size()]);
    }

    protected synchronized void remove(Decision decision) {
        this.m_queue.remove(decision);
    }

    public List<Decision> getActorDecisions(WikiSession session) {
        ArrayList<Decision> decisions = new ArrayList<Decision>();
        if (session.isAuthenticated()) {
            Principal[] principals = session.getPrincipals();
            Principal[] rolePrincipals = session.getRoles();
            for (Decision decision : this.m_queue) {
                Principal principal;
                Principal[] principalArray = principals;
                int n = principals.length;
                int n2 = 0;
                while (n2 < n) {
                    principal = principalArray[n2];
                    if (principal.equals(decision.getActor())) {
                        decisions.add(decision);
                    }
                    ++n2;
                }
                principalArray = rolePrincipals;
                n = rolePrincipals.length;
                n2 = 0;
                while (n2 < n) {
                    principal = principalArray[n2];
                    if (principal.equals(decision.getActor())) {
                        decisions.add(decision);
                    }
                    ++n2;
                }
            }
        }
        return decisions;
    }

    public void decide(Decision decision, Outcome outcome) throws WikiException {
        decision.decide(outcome);
        if (decision.isCompleted()) {
            this.remove(decision);
        }
    }

    public synchronized void reassign(Decision decision, Principal owner) throws WikiException {
        if (decision.isReassignable()) {
            decision.reassign(owner);
            return;
        }
        throw new IllegalStateException("Reassignments not allowed for this decision.");
    }

    private synchronized int nextId() {
        int current = this.m_next++;
        return current;
    }
}

