/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.util;

import java.lang.management.ManagementFactory;
import java.lang.ref.WeakReference;
import java.util.Date;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.timer.TimerNotification;
import org.apache.wiki.InternalWikiException;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.event.WikiEngineEvent;
import org.apache.wiki.event.WikiEvent;
import org.apache.wiki.event.WikiEventListener;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;

public abstract class WikiBackgroundThread
implements WikiEventListener {
    private final Logger m_log;
    private static final String[] ADD_NOTIFICATION_SIGNATURE = new String[]{String.class.getName(), String.class.getName(), Object.class.getName(), Date.class.getName(), "long"};
    private static final String[] REMOVE_NOTIFICATION_SIGNATURE = new String[]{Integer.class.getName()};
    private static final String[] UNREGISTER_TIMER_SIGNATURE = new String[]{ObjectName.class.getName()};
    private final WeakReference<WikiEngine> m_engine;
    private final ObjectName m_timer;
    private TimerListener m_timerListener = null;
    private String m_name;
    private final int m_sleepInterval;
    private int m_notificationId;

    public static final ObjectName registerTimer(WikiEngine engine) {
        try {
            ObjectName timer = WikiBackgroundThread.getTimer(engine);
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            if (!server.isRegistered(timer)) {
                server.createMBean("javax.management.timer.Timer", timer);
                server.invoke(timer, "start", new Object[0], new String[0]);
            }
            return timer;
        }
        catch (JMException e) {
            e.printStackTrace();
            throw new InternalWikiException("Could not register JMX timer: " + e.getMessage(), e);
        }
    }

    public static final void unregisterTimer(WikiEngine engine) {
        try {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            ObjectName timer = WikiBackgroundThread.getTimer(engine);
            server.invoke(timer, "stop", new Object[0], new String[0]);
            server.unregisterMBean(timer);
        }
        catch (InstanceNotFoundException server) {
        }
        catch (JMException e) {
            e.printStackTrace();
            throw new InternalWikiException("Could not unregister JMX timer: " + e.getMessage(), e);
        }
    }

    private static ObjectName getTimer(WikiEngine engine) throws JMException {
        return new ObjectName("JSPWiki:wiki=" + engine.getApplicationName() + ",component=timer,name=Timer service");
    }

    private static MBeanServer getMBeanServer() throws JMException {
        return ManagementFactory.getPlatformMBeanServer();
    }

    public WikiBackgroundThread(WikiEngine engine, int sleepInterval) {
        this.m_engine = new WeakReference<WikiEngine>(engine);
        this.m_name = this.getClass().getName();
        this.m_log = LoggerFactory.getLogger(this.getClass());
        this.m_notificationId = 0;
        this.m_sleepInterval = sleepInterval;
        this.m_timer = WikiBackgroundThread.registerTimer(engine);
        engine.addWikiEventListener(this);
    }

    public final void actionPerformed(WikiEvent event) {
        if (event instanceof WikiEngineEvent && ((WikiEngineEvent)event).getType() == 1) {
            this.shutdown();
        }
    }

    public abstract void backgroundTask() throws Exception;

    public final WikiEngine getEngine() {
        return (WikiEngine)this.m_engine.get();
    }

    public final String getName() {
        return this.m_name;
    }

    public final void setName(String name) {
        this.m_name = name;
    }

    public final void shutdown() {
        this.m_log.info("Stopping " + this.m_name + ".", new Object[0]);
        try {
            try {
                this.removeJMXListener();
                if (this.m_engine.get() != null) {
                    this.shutdownTask();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new InternalWikiException("Could not stop " + this.m_name + "!", e);
            }
        }
        catch (Throwable t) {
            this.m_log.error("Background task shutdown error: " + t.getMessage(), new Object[0]);
            t.printStackTrace();
            throw new InternalWikiException(t.getMessage());
        }
    }

    public void shutdownTask() throws Exception {
    }

    public final void start() {
        this.m_log.info("Starting " + this.getName() + ".", new Object[0]);
        try {
            if (this.m_engine.get() != null) {
                this.startupTask();
                this.addJMXListener();
            }
        }
        catch (JMException e) {
            e.printStackTrace();
            throw new InternalWikiException("Could not add JMX listener for " + this.m_name + "!", e);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new InternalWikiException("Could not start " + this.m_name + "!", e);
        }
    }

    public void startupTask() throws Exception {
    }

    private final void addJMXListener() throws JMException {
        MBeanServer server = WikiBackgroundThread.getMBeanServer();
        long interval = 1000L * (long)this.m_sleepInterval;
        Date startTime = new Date(new Date().getTime() + interval);
        Object[] objectArray = new Object[5];
        objectArray[0] = this.getClass().getName();
        objectArray[1] = "Timed task";
        objectArray[3] = startTime;
        objectArray[4] = interval;
        Object[] timerArgs = objectArray;
        this.m_notificationId = (Integer)server.invoke(this.m_timer, "addNotification", timerArgs, ADD_NOTIFICATION_SIGNATURE);
        this.m_timerListener = new TimerListener(this, this.m_notificationId);
        server.addNotificationListener(this.m_timer, this.m_timerListener, null, null);
        server.invoke(this.m_timer, "start", new Object[0], new String[0]);
    }

    private final void removeJMXListener() throws JMException {
        block2: {
            try {
                MBeanServer server = WikiBackgroundThread.getMBeanServer();
                server.removeNotificationListener(WikiBackgroundThread.getTimer((WikiEngine)this.m_engine.get()), this.m_timerListener);
                Object[] args = new Object[]{this.m_notificationId};
                server.invoke(this.m_timer, "removeNotification", args, REMOVE_NOTIFICATION_SIGNATURE);
            }
            catch (JMException e) {
                if (e.getCause() instanceof InstanceNotFoundException) break block2;
                throw e;
            }
        }
    }

    protected final void doBackgroundTask() {
        try {
            if (this.m_engine.get() != null) {
                this.m_log.debug("Running " + this.m_name + ".", new Object[0]);
                this.backgroundTask();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                this.m_log.error("Could not run " + this.m_name + "! Shutting it down.", new Object[0]);
                this.shutdown();
            }
            catch (Exception e2) {
                this.m_log.error("Could not shut down " + this.m_name + "!", new Object[0]);
                e2.printStackTrace();
            }
        }
    }

    public static class TimerListener
    implements NotificationListener {
        private final int m_timerId;
        private final WikiBackgroundThread m_task;

        TimerListener(WikiBackgroundThread task, int timerId) {
            this.m_timerId = timerId;
            this.m_task = task;
        }

        public void handleNotification(Notification notification, Object handback) {
            if (((TimerNotification)notification).getNotificationID() == this.m_timerId) {
                this.m_task.doBackgroundTask();
            }
        }
    }
}

