/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.util;

import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;

public class UtilJ2eeCompat {
    private static Logger log = LoggerFactory.getLogger(UtilJ2eeCompat.class.getName());
    public static final String TOMCAT = "Apache Tomcat";
    public static final String ORION = "Orion";
    public static final String RESIN = "Resin";
    public static final String REX_IP = "TradeCity";
    public static final String OC4J = "Oracle";
    public static final String JRUN = "JRun";
    public static final String JETTY = "Jetty";
    public static final String WEBSPHERE = "Websphere";
    public static final String WEBLOGIC = "WebLogic";
    public static final String GLASSFISH = "Sun Java System Application Server";
    protected static Boolean useOutputStreamValue = null;
    private static String m_serverInfo;

    public static boolean useOutputStream(String serverInfo) {
        if (useOutputStreamValue == null) {
            UtilJ2eeCompat.initCompatibilityOptions(serverInfo);
        }
        return useOutputStreamValue;
    }

    public static boolean useOutputStream(String serverInfo, Boolean boolInitialize) {
        if (useOutputStreamValue == null | boolInitialize) {
            UtilJ2eeCompat.initCompatibilityOptions(serverInfo);
        }
        return useOutputStreamValue;
    }

    protected static void initCompatibilityOptions(String serverInfo) {
        log.info("serverInfo: " + serverInfo, new Object[0]);
        m_serverInfo = serverInfo;
        boolean useStream = false;
        if (serverInfo.indexOf(RESIN) >= 0) {
            log.info("Resin detected", new Object[0]);
        } else if (serverInfo.indexOf(REX_IP) >= 0) {
            log.info("TradeCity detected", new Object[0]);
        } else if (serverInfo.indexOf(TOMCAT) >= 0) {
            log.info("Apache Tomcat detected", new Object[0]);
        } else if (serverInfo.indexOf(JRUN) >= 0) {
            log.info("JRun detected", new Object[0]);
        } else if (serverInfo.indexOf(JETTY) >= 0) {
            log.info("Jetty detected", new Object[0]);
        } else if (serverInfo.indexOf(ORION) >= 0) {
            log.info("Orion detected", new Object[0]);
        } else if (serverInfo.indexOf(WEBSPHERE) >= 0) {
            log.info("Websphere detected", new Object[0]);
        } else if (serverInfo.indexOf(WEBLOGIC) >= 0) {
            log.info("WebLogic detected", new Object[0]);
        } else if (serverInfo.indexOf(GLASSFISH) >= 0) {
            log.info("Sun Java System Application Server detected", new Object[0]);
        } else if (serverInfo.indexOf(OC4J) >= 0) {
            log.info("Oracle Container for JEE detected", new Object[0]);
            useStream = true;
        }
        useOutputStreamValue = new Boolean(useStream);
    }

    public static String getServerInfo() {
        return m_serverInfo;
    }
}

