/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.util;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimedCounterList<T>
extends AbstractList<T> {
    private ArrayList<CounterItem<T>> m_list = new ArrayList();
    private ReadWriteLock m_lock = new ReentrantReadWriteLock();

    @Override
    public T set(int index, T element) {
        Object t;
        this.m_lock.writeLock().lock();
        try {
            t = ((CounterItem)this.m_list.set(index, new CounterItem<T>(element))).m_obj;
        }
        finally {
            this.m_lock.writeLock().unlock();
        }
        return (T)t;
    }

    @Override
    public T get(int index) {
        Object t;
        this.m_lock.readLock().lock();
        try {
            t = ((CounterItem)this.m_list.get(index)).m_obj;
        }
        finally {
            this.m_lock.readLock().unlock();
        }
        return (T)t;
    }

    @Override
    public int size() {
        this.m_lock.readLock().lock();
        int size = 0;
        try {
            size = this.m_list.size();
        }
        finally {
            this.m_lock.readLock().unlock();
        }
        return size;
    }

    @Override
    public void add(int index, T element) {
        this.m_lock.writeLock().lock();
        try {
            this.m_list.add(index, new CounterItem<T>(element));
        }
        finally {
            this.m_lock.writeLock().unlock();
        }
    }

    @Override
    public T remove(int index) {
        Object t;
        this.m_lock.writeLock().lock();
        try {
            t = ((CounterItem)this.m_list.remove(index)).m_obj;
        }
        finally {
            this.m_lock.writeLock().unlock();
        }
        return (T)t;
    }

    public int count(T obj) {
        int c = 0;
        this.m_lock.readLock().lock();
        try {
            for (CounterItem<T> i : this.m_list) {
                if (!((CounterItem)i).m_obj.equals(obj)) continue;
                ++c;
            }
        }
        finally {
            this.m_lock.readLock().unlock();
        }
        return c;
    }

    public void cleanup(long maxage) {
        this.m_lock.writeLock().lock();
        try {
            long now = System.currentTimeMillis();
            Iterator<CounterItem<T>> i = this.m_list.iterator();
            while (i.hasNext()) {
                CounterItem<T> ci = i.next();
                long age = now - ((CounterItem)ci).m_addTime;
                if (age <= maxage) continue;
                i.remove();
            }
        }
        finally {
            this.m_lock.writeLock().unlock();
        }
    }

    public long getAddTime(int index) {
        this.m_lock.readLock().lock();
        long res = 0L;
        try {
            res = ((CounterItem)this.m_list.get(index)).m_addTime;
        }
        finally {
            this.m_lock.readLock().unlock();
        }
        return res;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CounterItem<E> {
        private E m_obj;
        private long m_addTime = System.currentTimeMillis();

        public CounterItem(E o) {
            this.m_obj = o;
        }
    }
}

