/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Serializer {
    protected static final String BASE64_PREFIX = "base64 ";

    private Serializer() {
    }

    public static Map<String, ? extends Serializable> deserializeFromBase64(String rawString) throws IOException {
        HashMap attributes;
        byte[] decodedBytes = Base64.decodeBase64((byte[])rawString.getBytes("UTF-8"));
        ByteArrayInputStream bytesIn = new ByteArrayInputStream(decodedBytes);
        ObjectInputStream in = new ObjectInputStream(bytesIn);
        try {
            try {
                attributes = (HashMap)in.readObject();
            }
            catch (ClassNotFoundException e) {
                throw new IOException("Could not deserialiaze user profile attributes. Reason: " + e.getMessage());
            }
        }
        finally {
            in.close();
        }
        return attributes;
    }

    public static String serializeToBase64(Map<String, Serializable> map) throws IOException {
        HashMap<String, Serializable> serialMap = new HashMap<String, Serializable>();
        serialMap.putAll(map);
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bytesOut);
        out.writeObject(serialMap);
        out.close();
        byte[] result = Base64.encodeBase64((byte[])bytesOut.toByteArray());
        return new String(result);
    }
}

