/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.util;

public final class RegExpUtil {
    public static final int DEFAULT_MASK = 0;
    public static final int CASE_INSENSITIVE_MASK = 1;
    public static final int STAR_CANNOT_MATCH_NULL_MASK = 2;
    public static final int QUESTION_MATCHES_ZERO_OR_ONE_MASK = 4;
    public static final int READ_ONLY_MASK = 8;

    private RegExpUtil() {
    }

    public static String globToPerl5(char[] pattern, int options) {
        boolean inCharSet = false;
        boolean starCannotMatchNull = false;
        boolean questionMatchesZero = false;
        StringBuffer buffer = new StringBuffer(2 * pattern.length);
        inCharSet = false;
        questionMatchesZero = (options & 4) != 0;
        starCannotMatchNull = (options & 2) != 0;
        int ch = 0;
        while (ch < pattern.length) {
            block0 : switch (pattern[ch]) {
                case '*': {
                    if (inCharSet) {
                        buffer.append('*');
                        break;
                    }
                    if (starCannotMatchNull) {
                        buffer.append(".+");
                        break;
                    }
                    buffer.append(".*");
                    break;
                }
                case '?': {
                    if (inCharSet) {
                        buffer.append('?');
                        break;
                    }
                    if (questionMatchesZero) {
                        buffer.append(".?");
                        break;
                    }
                    buffer.append('.');
                    break;
                }
                case '[': {
                    inCharSet = true;
                    buffer.append(pattern[ch]);
                    if (ch + 1 >= pattern.length) break;
                    switch (pattern[ch + 1]) {
                        case '!': 
                        case '^': {
                            buffer.append('^');
                            ++ch;
                            break block0;
                        }
                        case ']': {
                            buffer.append(']');
                            ++ch;
                            break block0;
                        }
                    }
                    break;
                }
                case ']': {
                    inCharSet = false;
                    buffer.append(pattern[ch]);
                    break;
                }
                case '\\': {
                    buffer.append('\\');
                    if (ch == pattern.length - 1) {
                        buffer.append('\\');
                        break;
                    }
                    if (RegExpUtil.isGlobMetaCharacter(pattern[ch + 1])) {
                        buffer.append(pattern[++ch]);
                        break;
                    }
                    buffer.append('\\');
                    break;
                }
                default: {
                    if (!inCharSet && RegExpUtil.isPerl5MetaCharacter(pattern[ch])) {
                        buffer.append('\\');
                    }
                    buffer.append(pattern[ch]);
                }
            }
            ++ch;
        }
        return buffer.toString();
    }

    private static boolean isPerl5MetaCharacter(char ch) {
        return "'*?+[]()|^$.{}\\".indexOf(ch) >= 0;
    }

    private static boolean isGlobMetaCharacter(char ch) {
        return "*?[]".indexOf(ch) >= 0;
    }
}

