/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.util;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Date;
import org.apache.wiki.api.WikiPage;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageTimeComparator
implements Comparator<WikiPage>,
Serializable {
    private static final long serialVersionUID = 0L;
    private final Order m_order;
    static Logger log = LoggerFactory.getLogger(PageTimeComparator.class);
    public static final Comparator<WikiPage> DEFAULT_PAGETIME_COMPARATOR = new PageTimeComparator(Order.ASCENDING);

    public PageTimeComparator() {
        this(Order.ASCENDING);
    }

    public PageTimeComparator(Order order) {
        this.m_order = order;
    }

    @Override
    public int compare(WikiPage w1, WikiPage w2) {
        if (w1 == null || w2 == null) {
            log.error("W1 or W2 is NULL in PageTimeComparator!", new Object[0]);
            return 0;
        }
        Date w1LastMod = w1.getLastModified();
        Date w2LastMod = w2.getLastModified();
        if (w1LastMod == null) {
            log.error("NULL MODIFY DATE WITH " + w1.getName(), new Object[0]);
            return 0;
        }
        if (w2LastMod == null) {
            log.error("NULL MODIFY DATE WITH " + w2.getName(), new Object[0]);
            return 0;
        }
        int timecomparison = w2LastMod.compareTo(w1LastMod) * (this.m_order == Order.DESCENDING ? 1 : -1);
        if (timecomparison == 0) {
            return w1.getName().compareTo(w2.getName());
        }
        return timecomparison;
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof PageTimeComparator;
    }

    public int hashcode() {
        return 864420504;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Order {
        ASCENDING,
        DESCENDING;

    }
}

