/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.util;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import javax.jcr.LoginException;
import javax.jcr.RepositoryException;
import javax.servlet.ServletContext;
import net.sourceforge.stripes.mock.MockServletContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.api.WikiException;
import org.apache.wiki.content.ContentManager;
import org.apache.wiki.content.PageAlreadyExistsException;
import org.apache.wiki.util.CommentedProperties;

public final class Import {
    private Import() {
    }

    private static void usage() {
        System.out.println("Usage: java " + Import.class.getName() + " -p <propertyfile> <xmlfile>");
        System.exit(1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getArg(String[] params, String option2) {
        int i = 0;
        while (i < params.length) {
            if (option2 == null) {
                if (!params[i].startsWith("-")) return params[i];
                ++i;
            } else {
                if (params[i].equals(option2)) {
                    if (i < params.length - 1) {
                        return params[i + 1];
                    }
                    if (!params[i + 1].startsWith("-")) return "";
                    return "";
                }
                if (params[i].startsWith(option2)) {
                    return params[i].substring(option2.length());
                }
            }
            ++i;
        }
        return null;
    }

    public static void main(String[] argv) throws FileNotFoundException, IOException, WikiException, LoginException, RepositoryException, InterruptedException, PageAlreadyExistsException {
        String propfile;
        if (argv.length < 2) {
            Import.usage();
        }
        if ((propfile = Import.getArg(argv, "-p")) == null) {
            Import.usage();
        }
        System.out.println("Using propertyfile '" + propfile + "' to configure JSPWiki");
        String xmlfile = Import.getArg(argv, null);
        if (xmlfile == null) {
            Import.usage();
        }
        System.out.println("Reading contents of repository from '" + xmlfile + "'");
        CommentedProperties props = new CommentedProperties();
        try {
            ((Properties)props).load(new FileInputStream(propfile));
        }
        catch (IOException e) {
            System.err.println("Could not open property file " + e.getMessage());
            System.exit(5);
        }
        WikiEngine engine = null;
        try {
            engine = WikiEngine.getInstance((ServletContext)new MockServletContext("JSPWiki"), (Properties)props);
        }
        catch (Exception e) {
            System.err.println("Error starting JSPWiki: " + e.getMessage());
            e.printStackTrace(System.err);
            System.exit(5);
        }
        Thread.sleep(10L);
        try {
            ContentManager mgr = engine.getContentManager();
            mgr.importXML(xmlfile);
        }
        finally {
            engine.shutdown();
        }
        System.out.println("Importing completed.");
    }
}

