/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.wiki.api.WikiPage;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;

public final class HttpUtil {
    static Logger log = LoggerFactory.getLogger(HttpUtil.class);

    private HttpUtil() {
    }

    public static String retrieveCookieValue(HttpServletRequest request, String cookieName) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            int i = 0;
            while (i < cookies.length) {
                if (cookies[i].getName().equals(cookieName)) {
                    String value = cookies[i].getValue();
                    if (value.length() == 0) {
                        return null;
                    }
                    if (value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"') {
                        value = value.substring(1, value.length() - 1);
                    }
                    return value;
                }
                ++i;
            }
        }
        return null;
    }

    public static String createETag(WikiPage p) {
        return Long.toString((long)p.getName().hashCode() ^ p.getLastModified().getTime());
    }

    public static boolean checkFor304(HttpServletRequest req, WikiPage page) {
        if (!"no-cache".equalsIgnoreCase(req.getHeader("Pragma")) && !"no-cache".equalsIgnoreCase(req.getHeader("cache-control"))) {
            Date lastModified;
            SimpleDateFormat rfcDateFormat;
            block9: {
                String thisTag = HttpUtil.createETag(page);
                String eTag = req.getHeader("If-None-Match");
                if (eTag != null && eTag.equals(thisTag)) {
                    return true;
                }
                rfcDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
                lastModified = page.getLastModified();
                long ifModifiedSince = req.getDateHeader("If-Modified-Since");
                if (ifModifiedSince == -1L) break block9;
                long lastModifiedTime = lastModified.getTime();
                if (lastModifiedTime <= ifModifiedSince) {
                    return true;
                }
            }
            try {
                Date ifModifiedSinceDate;
                String s = req.getHeader("If-Modified-Since");
                if (s != null && lastModified.before(ifModifiedSinceDate = rfcDateFormat.parse(s))) {
                    return true;
                }
            }
            catch (ParseException e) {
                try {
                    log.warn(e.getLocalizedMessage(), e, new Object[0]);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    public static String guessValidURI(String uri) {
        if (uri.indexOf(64) != -1) {
            if (!uri.startsWith("mailto:")) {
                uri = "mailto:" + uri;
            }
        } else if (uri.length() > 0 && !uri.startsWith("http://") && !uri.startsWith("https://")) {
            uri = "http://" + uri;
        }
        return uri;
    }
}

