/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;

public final class FileUtil {
    private static final int BUFFER_SIZE = 4096;

    private FileUtil() {
    }

    public static File newTmpFile(String content, String encoding) throws IOException {
        Writer out = null;
        Reader in = null;
        File f = null;
        try {
            f = File.createTempFile("jspwiki", null);
            in = new StringReader(content);
            out = new OutputStreamWriter((OutputStream)new FileOutputStream(f), encoding);
            FileUtil.copyContents(in, out);
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
        return f;
    }

    public static File newTmpFile(String content) throws IOException {
        return FileUtil.newTmpFile(content, "ISO-8859-1");
    }

    public static String runSimpleCommand(String command, String directory) throws IOException, InterruptedException {
        StringBuilder result = new StringBuilder();
        Logger log = LoggerFactory.getLogger(FileUtil.class);
        log.info("Running simple command " + command + " in " + directory, new Object[0]);
        Process process = Runtime.getRuntime().exec(command, null, new File(directory));
        BufferedReader stdout = null;
        BufferedReader stderr = null;
        try {
            String line;
            stdout = new BufferedReader(new InputStreamReader(process.getInputStream()));
            stderr = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            while ((line = stdout.readLine()) != null) {
                result.append(String.valueOf(line) + "\n");
            }
            StringBuilder error = new StringBuilder();
            while ((line = stderr.readLine()) != null) {
                error.append(String.valueOf(line) + "\n");
            }
            if (error.length() > 0) {
                log.error("Command failed, error stream is: " + error, new Object[0]);
            }
            process.waitFor();
        }
        finally {
            process.getInputStream().close();
            if (stdout != null) {
                stdout.close();
            }
            if (stderr != null) {
                stderr.close();
            }
        }
        return result.toString();
    }

    public static void copyContents(Reader in, Writer out) throws IOException {
        char[] buf = new char[4096];
        int bytesRead = 0;
        while ((bytesRead = in.read(buf)) > 0) {
            out.write(buf, 0, bytesRead);
        }
        out.flush();
    }

    public static void copyContents(InputStream in, OutputStream out) throws IOException {
        byte[] buf = new byte[4096];
        int bytesRead = 0;
        while ((bytesRead = in.read(buf)) > 0) {
            out.write(buf, 0, bytesRead);
        }
        out.flush();
    }

    public static String readContents(InputStream input2, String encoding) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        FileUtil.copyContents(input2, out);
        ByteBuffer bbuf = ByteBuffer.wrap(out.toByteArray());
        Charset cset = Charset.forName(encoding);
        CharsetDecoder csetdecoder = cset.newDecoder();
        csetdecoder.onMalformedInput(CodingErrorAction.REPORT);
        csetdecoder.onUnmappableCharacter(CodingErrorAction.REPORT);
        try {
            CharBuffer cbuf = csetdecoder.decode(bbuf);
            return cbuf.toString();
        }
        catch (CharacterCodingException e) {
            Charset latin1 = Charset.forName("ISO-8859-1");
            CharsetDecoder l1decoder = latin1.newDecoder();
            l1decoder.onMalformedInput(CodingErrorAction.REPORT);
            l1decoder.onUnmappableCharacter(CodingErrorAction.REPORT);
            try {
                bbuf = ByteBuffer.wrap(out.toByteArray());
                CharBuffer cbuf = l1decoder.decode(bbuf);
                return cbuf.toString();
            }
            catch (CharacterCodingException ex) {
                throw (CharacterCodingException)ex.fillInStackTrace();
            }
        }
    }

    public static String readContents(Reader in) throws IOException {
        StringWriter out = null;
        try {
            out = new StringWriter();
            FileUtil.copyContents(in, out);
            String string = ((Object)out).toString();
            return string;
        }
        finally {
            try {
                ((Writer)out).close();
            }
            catch (Exception e) {
                Logger log = LoggerFactory.getLogger(FileUtil.class);
                log.error("Not able to close the stream while reading contents.", new Object[0]);
            }
        }
    }

    public static String getThrowingMethod(Throwable t) {
        StackTraceElement[] trace = t.getStackTrace();
        StringBuilder sb = new StringBuilder();
        if (trace == null || trace.length == 0) {
            sb.append("[Stack trace not available]");
        } else {
            sb.append(trace[0].isNativeMethod() ? "native method" : "");
            sb.append(trace[0].getClassName());
            sb.append(".");
            sb.append(String.valueOf(trace[0].getMethodName()) + "(), line " + trace[0].getLineNumber());
        }
        return sb.toString();
    }
}

