/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.util;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Random;
import org.apache.commons.codec.binary.Base64;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;

public final class CryptoUtil {
    private static final Logger log = LoggerFactory.getLogger(CryptoUtil.class);
    private static final String SSHA = "{SSHA}";
    private static final Random RANDOM = new SecureRandom();
    private static final int DEFAULT_SALT_SIZE = 8;
    private static final Object HELP = "--help";
    private static final Object HASH = "--hash";
    private static final Object VERIFY = "--verify";

    private CryptoUtil() {
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0 || args.length == 1 && HELP.equals(args[0])) {
            System.out.println("Usage: CryptUtil [options] ");
            System.out.println("   --hash   password             create hash for password");
            System.out.println("   --verify password digest      verify password for digest");
            System.exit(0);
        }
        if (HASH.equals(args[0])) {
            if (args.length < 2) {
                throw new IllegalArgumentException("Error: --hash requires a 'password' argument.");
            }
            String password = args[1].trim();
            System.out.println(CryptoUtil.getSaltedPassword(password.getBytes("UTF-8")));
        } else if (VERIFY.equals(args[0])) {
            if (args.length < 3) {
                throw new IllegalArgumentException("Error: --hash requires 'password' and 'digest' arguments.");
            }
            String password = args[1].trim();
            String digest = args[2].trim();
            System.out.println(CryptoUtil.verifySaltedPassword(password.getBytes("UTF-8"), digest));
        } else {
            System.out.println("Wrong usage. Try --help.");
        }
    }

    public static String getSaltedPassword(byte[] password) throws NoSuchAlgorithmException {
        byte[] salt = new byte[8];
        RANDOM.nextBytes(salt);
        return CryptoUtil.getSaltedPassword(password, salt);
    }

    protected static String getSaltedPassword(byte[] password, byte[] salt) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("SHA");
        digest.update(password);
        byte[] hash = digest.digest(salt);
        byte[] all = new byte[hash.length + salt.length];
        int i = 0;
        while (i < hash.length) {
            all[i] = hash[i];
            ++i;
        }
        i = 0;
        while (i < salt.length) {
            all[hash.length + i] = salt[i];
            ++i;
        }
        byte[] base64 = Base64.encodeBase64((byte[])all);
        String base64String = null;
        try {
            base64String = SSHA + new String(base64, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("You do not have UTF-8!?!", new Object[0]);
        }
        return base64String;
    }

    public static boolean verifySaltedPassword(byte[] password, String entry) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        if (!entry.startsWith(SSHA)) {
            throw new IllegalArgumentException("Hash not prefixed by {SSHA}; is it really a salted hash?");
        }
        byte[] challenge = Base64.decodeBase64((byte[])entry.substring(6).getBytes("UTF-8"));
        byte[] passwordHash = CryptoUtil.extractPasswordHash(challenge);
        byte[] salt = CryptoUtil.extractSalt(challenge);
        MessageDigest digest = MessageDigest.getInstance("SHA");
        digest.update(password);
        byte[] hash = digest.digest(salt);
        return Arrays.equals(passwordHash, hash);
    }

    protected static byte[] extractPasswordHash(byte[] digest) throws IllegalArgumentException {
        if (digest.length < 20) {
            throw new IllegalArgumentException("Hash was less than 20 characters; could not extract password hash!");
        }
        byte[] hash = new byte[20];
        int i = 0;
        while (i < 20) {
            hash[i] = digest[i];
            ++i;
        }
        return hash;
    }

    protected static byte[] extractSalt(byte[] digest) throws IllegalArgumentException {
        if (digest.length <= 20) {
            throw new IllegalArgumentException("Hash was less than 21 characters; we found no salt!");
        }
        byte[] salt = new byte[digest.length - 20];
        int i = 20;
        while (i < digest.length) {
            salt[i - 20] = digest[i];
            ++i;
        }
        return salt;
    }
}

