/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.util;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.wiki.util.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommentedProperties
extends Properties {
    private static final long serialVersionUID = 8057284636436329669L;
    private Map<String, List<String>> m_propertyComments = new HashMap<String, List<String>>();
    private Set<Object> m_keys = new LinkedHashSet<Object>();
    private List<String> m_trailingComments = null;
    private final String m_br;
    private char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final Pattern LINE_TRIMMER = Pattern.compile("^[ \\r\\n\\t\\f]*(.*?)[ \\r\\n\\t\\f]*$");
    private static final Pattern BLANK_LINE_DETECTOR = Pattern.compile("^[ \\r\\n\\t\\f]*$");

    public CommentedProperties() {
        this.m_br = System.getProperty("line.separator");
    }

    public CommentedProperties(Properties defaultValues) {
        super(defaultValues);
        this.m_br = System.getProperty("line.separator");
    }

    @Override
    public synchronized void load(InputStream inStream) throws IOException {
        String propertyString = FileUtil.readContents(inStream, "ISO-8859-1");
        super.load(new ByteArrayInputStream(propertyString.getBytes("ISO-8859-1")));
        this.loadComments(propertyString);
    }

    @Override
    public synchronized void load(Reader in) throws IOException {
        String propertyString = FileUtil.readContents(in);
        super.load(new ByteArrayInputStream(propertyString.getBytes("ISO-8859-1")));
        this.loadComments(propertyString);
    }

    @Override
    public synchronized void store(OutputStream out, String comments) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, "8859_1"));
        this.writeProperties(writer, comments);
        writer.flush();
    }

    private void writeProperties(BufferedWriter writer, String comments) throws IOException {
        if (comments != null) {
            writer.write("# ");
            this.writeText(writer, "# " + comments, EscapeMode.COMMENT);
            writer.newLine();
            writer.write("# " + new Date().toString());
            writer.newLine();
        }
        for (Object object : this.m_keys) {
            Object value = this.get(object);
            List<String> commentList = this.m_propertyComments.get(object);
            this.writeComments(writer, commentList);
            this.writeText(writer, object, EscapeMode.KEY);
            writer.write(61);
            this.writeText(writer, value, EscapeMode.ENTRY);
            writer.newLine();
        }
        for (Map.Entry entry : this.entrySet()) {
            String key = entry.getKey().toString();
            if (this.m_keys.contains(key)) continue;
            Object value = entry.getValue();
            this.writeText(writer, key, EscapeMode.KEY);
            writer.write(61);
            this.writeText(writer, value, EscapeMode.ENTRY);
            writer.newLine();
        }
        this.writeComments(writer, this.m_trailingComments);
    }

    private void writeComments(BufferedWriter writer, List<String> commentList) throws IOException {
        if (commentList != null) {
            for (String comment : commentList) {
                if (BLANK_LINE_DETECTOR.matcher(comment).matches()) {
                    writer.write(comment);
                } else {
                    writer.write("#");
                    this.writeText(writer, comment, EscapeMode.COMMENT);
                }
                writer.newLine();
            }
        }
    }

    private void writeText(BufferedWriter writer, Object entry, EscapeMode mode) throws IOException {
        String e = entry == null ? "" : entry.toString();
        boolean leadingSpaces = true;
        int i = 0;
        while (i < e.length()) {
            char ch = e.charAt(i);
            switch (ch) {
                case '\t': {
                    leadingSpaces = false;
                    writer.write("\\t");
                    break;
                }
                case '\f': {
                    leadingSpaces = false;
                    writer.write("\\f");
                    break;
                }
                case '\n': {
                    leadingSpaces = false;
                    if (mode == EscapeMode.COMMENT) break;
                    writer.write("\\n");
                    break;
                }
                case '\r': {
                    leadingSpaces = false;
                    if (mode == EscapeMode.COMMENT) break;
                    writer.write("\\r");
                    break;
                }
                case ' ': {
                    if (mode == EscapeMode.ENTRY && leadingSpaces || mode == EscapeMode.KEY) {
                        writer.write(92);
                    }
                    writer.write(32);
                    break;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': 
                case '\\': {
                    leadingSpaces = false;
                    if (mode == EscapeMode.KEY) {
                        writer.write(92);
                    }
                    writer.write(ch);
                    break;
                }
                default: {
                    leadingSpaces = false;
                    if (ch < ' ' || ch > '~' && ch < '\u00a0' || ch > '\u00ff') {
                        writer.write(92);
                        writer.write(117);
                        writer.write(this.HEX[ch >>> 12 & 0xF]);
                        writer.write(this.HEX[ch >>> 8 & 0xF]);
                        writer.write(this.HEX[ch >>> 4 & 0xF]);
                        writer.write(this.HEX[ch & 0xF]);
                        break;
                    }
                    writer.write(ch);
                }
            }
            ++i;
        }
    }

    @Override
    public synchronized String toString() {
        StringWriter s = new StringWriter();
        BufferedWriter writer = new BufferedWriter(s);
        try {
            this.writeProperties(writer, null);
            writer.flush();
            return s.toString();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private void loadComments(String propertyString) throws IOException {
        LineNumberReader reader = new LineNumberReader(new StringReader(propertyString));
        String line = null;
        boolean inProperty = false;
        ArrayList<String> commentList = new ArrayList<String>();
        while ((line = reader.readLine()) != null) {
            String key;
            Matcher m = LINE_TRIMMER.matcher(line);
            if (!m.matches()) continue;
            String text = m.group(1);
            boolean isComment = text.startsWith("#") || text.startsWith("!");
            boolean isWhitespace = BLANK_LINE_DETECTOR.matcher(text).matches();
            if (isComment) {
                commentList.add(text.substring(1));
                inProperty = false;
                continue;
            }
            if (isWhitespace && !inProperty) {
                commentList.add(text);
                continue;
            }
            if (inProperty || (key = this.extractKey(text)) == null) continue;
            String value = this.getProperty(key);
            if (value != null && commentList.size() > 0) {
                this.m_propertyComments.put(key, commentList);
                this.m_keys.add(key);
            }
            inProperty = true;
            commentList = new ArrayList();
        }
        this.m_trailingComments = commentList;
        reader.close();
    }

    protected String extractKey(String text) {
        char[] chars = text.toCharArray();
        int lastChar = 32;
        int i = 0;
        while (i < chars.length) {
            char ch = chars[i];
            switch (ch) {
                case '\t': 
                case '\f': 
                case ' ': 
                case ':': 
                case '=': {
                    if (lastChar == 39) break;
                    return text.substring(0, i);
                }
            }
            ++i;
        }
        return null;
    }

    public String getComment(String key) {
        StringBuffer b = new StringBuffer();
        List<String> commentList = this.m_propertyComments.get(key);
        if (commentList == null) {
            return null;
        }
        for (String comment : commentList) {
            b.append(comment);
            if (commentList.indexOf(comment) >= commentList.size() - 1) continue;
            b.append(this.m_br);
        }
        return b.toString();
    }

    public synchronized Object setProperty(String key, String value, String comment) {
        if (key != null) {
            if (comment != null && (comment = comment.trim()).length() > 0) {
                ArrayList<String> commentList = new ArrayList<String>();
                commentList.add(comment);
                this.m_propertyComments.put(key, commentList);
            }
            this.m_keys.add(key);
        }
        return super.setProperty(key, value);
    }

    @Override
    public synchronized Object setProperty(String key, String value) {
        return this.setProperty(key, value, null);
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        if (key != null) {
            this.m_keys.add(key);
        }
        return super.put(key, value);
    }

    @Override
    public synchronized void putAll(Map<? extends Object, ? extends Object> t) {
        for (Object object : t.keySet()) {
            if (object == null) continue;
            this.m_keys.add(object);
        }
        super.putAll(t);
    }

    @Override
    public synchronized Object remove(Object key) {
        if (key != null) {
            this.m_propertyComments.remove(key);
            this.m_keys.remove(key);
        }
        return super.remove(key);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum EscapeMode {
        COMMENT,
        KEY,
        ENTRY;

    }
}

