/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.util;

import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.wiki.api.WikiException;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.xpath.XPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassUtil {
    private static final Logger log = LoggerFactory.getLogger(ClassUtil.class);
    public static final String MAPPINGS = "/ini/classmappings.xml";
    private static Map<String, String> c_classMappings = new Hashtable<String, String>();

    static {
        try {
            InputStream is = ClassUtil.class.getResourceAsStream(MAPPINGS);
            if (is != null) {
                Document doc = new SAXBuilder().build(is);
                XPath xpath = XPath.newInstance((String)"/classmappings/mapping");
                List nodes = xpath.selectNodes((Object)doc);
                for (Element f : nodes) {
                    String key = f.getChildText("requestedClass");
                    String className = f.getChildText("mappedClass");
                    c_classMappings.put(key, className);
                    log.debug("Mapped class '" + key + "' to class '" + className + "'", new Object[0]);
                }
            } else {
                log.info("Didn't find class mapping document in /ini/classmappings.xml", new Object[0]);
            }
        }
        catch (Exception ex) {
            log.error("Unable to parse mappings document!", ex);
        }
    }

    private ClassUtil() {
    }

    /*
     * Unable to fully structure code
     */
    public static Class<?> findClass(List<String> packages, String className) throws ClassNotFoundException {
        loader = ClassUtil.class.getClassLoader();
        try {
            return loader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            ** for (packageName : packages)
        }
lbl-1000:
        // 1 sources

        {
            try {
                return loader.loadClass(String.valueOf(packageName) + "." + className);
            }
            catch (ClassNotFoundException var6_6) {
                // empty catch block
            }
            continue;
        }
lbl11:
        // 1 sources

        throw new ClassNotFoundException("Class '" + className + "' not found in search path!");
    }

    public static Class<?> findClass(String packageName, String className) throws ClassNotFoundException {
        ArrayList<String> list = new ArrayList<String>();
        list.add(packageName);
        return ClassUtil.findClass(list, className);
    }

    public static Object getMappedObject(String requestedClass) throws WikiException {
        Object[] initargs = new Object[]{};
        return ClassUtil.getMappedObject(requestedClass, initargs);
    }

    public static Object getMappedObject(String requestedClass, Object arg1) throws WikiException {
        Object[] initargs = new Object[]{arg1};
        return ClassUtil.getMappedObject(requestedClass, initargs);
    }

    public static Object getMappedObject(String requestedClass, Object arg1, Object arg2) throws WikiException {
        Object[] initargs = new Object[]{arg1, arg2};
        return ClassUtil.getMappedObject(requestedClass, initargs);
    }

    public static Object getMappedObject(String requestedClass, Object[] initargs) throws WikiException {
        try {
            Class<?> cl = ClassUtil.getMappedClass(requestedClass);
            Constructor<?>[] ctors = cl.getConstructors();
            int c = 0;
            while (c < ctors.length) {
                Class<?>[] params = ctors[c].getParameterTypes();
                if (params.length == initargs.length) {
                    int arg = 0;
                    while (arg < initargs.length) {
                        if (params[arg].isAssignableFrom(initargs[arg].getClass())) {
                            return ctors[c].newInstance(initargs);
                        }
                        ++arg;
                    }
                }
                ++c;
            }
            Object o = cl.newInstance();
            return o;
        }
        catch (InstantiationException e) {
            log.info("%1$s %2$s", "Cannot instantiate requested class " + requestedClass, e);
            throw new WikiException("Failed to instantiate class " + requestedClass, e);
        }
        catch (IllegalAccessException e) {
            log.info("%1$s %2$s", "Cannot access requested class " + requestedClass, e);
            throw new WikiException("Failed to instantiate class " + requestedClass, e);
        }
        catch (IllegalArgumentException e) {
            log.info("%1$s %2$s", "Illegal arguments when constructing new object", e);
            throw new WikiException("Failed to instantiate class " + requestedClass, e);
        }
        catch (InvocationTargetException e) {
            log.info("%1$s %2$s", "Failed to invoke class " + requestedClass, e.getCause());
            throw new WikiException("Failed to invoke class " + requestedClass + ", reason: " + e.getCause(), e);
        }
    }

    private static Class<?> getMappedClass(String requestedClass) throws WikiException {
        String mappedClass = c_classMappings.get(requestedClass);
        if (mappedClass == null) {
            mappedClass = requestedClass;
        }
        try {
            Class<?> cl = Class.forName(mappedClass);
            return cl;
        }
        catch (ClassNotFoundException e) {
            log.info("Cannot find requested class", e, new Object[0]);
            throw new WikiException("Failed to instantiate class " + requestedClass, e);
        }
    }
}

