/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.url;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.config.Configuration;
import net.sourceforge.stripes.controller.ActionResolver;
import net.sourceforge.stripes.controller.AnnotatedClassActionResolver;
import net.sourceforge.stripes.controller.StripesFilter;
import net.sourceforge.stripes.controller.UrlBinding;
import net.sourceforge.stripes.controller.UrlBindingFactory;
import net.sourceforge.stripes.controller.UrlBindingParameter;
import net.sourceforge.stripes.util.UrlBuilder;
import net.sourceforge.stripes.util.bean.ParseException;
import org.apache.commons.lang.StringUtils;
import org.apache.wiki.InternalWikiException;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.action.AbstractPageActionBean;
import org.apache.wiki.action.GroupActionBean;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.apache.wiki.ui.stripes.HandlerInfo;
import org.apache.wiki.url.URLConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StripesURLConstructor
implements URLConstructor {
    private static final Logger log = LoggerFactory.getLogger(StripesURLConstructor.class);
    private String m_pathPrefix;
    private WikiEngine m_engine;
    private UrlBindingFactory m_urlBindingFactory = null;
    private String m_baseUrl;

    @Override
    public String makeURL(String context, String name, boolean absolute, String parameters) {
        UrlBuilder urlBuilder;
        boolean engineAbsolute;
        if (this.m_urlBindingFactory == null) {
            this.m_urlBindingFactory = this.getUrlBindingFactory();
        }
        String pathPrefix = absolute | (engineAbsolute = "absolute".equals(this.m_engine.getWikiProperties().getProperty("jspwiki.referenceStyle"))) ? this.m_baseUrl : this.m_pathPrefix;
        Map<String, String> params = this.splitParamString(parameters);
        if ("none".equals(context)) {
            urlBuilder = new UrlBuilder(null, "/" + name, false);
        } else {
            HandlerInfo handler = this.m_engine.getWikiContextFactory().findEventHandler(context);
            Class<? extends ActionBean> beanClass = handler.getActionBeanClass();
            UrlBinding mapping = this.m_urlBindingFactory.getBindingPrototype(beanClass);
            String baseUrl = mapping == null ? null : mapping.getPath();
            urlBuilder = new UrlBuilder(null, baseUrl, false);
            if (name != null) {
                if (AbstractPageActionBean.class.isAssignableFrom(beanClass)) {
                    urlBuilder.addParameter("page", new Object[]{name});
                } else if (GroupActionBean.class.isAssignableFrom(beanClass)) {
                    urlBuilder.addParameter("group", new Object[]{name});
                }
            }
        }
        if (params != null) {
            for (Map.Entry<String, String> param : params.entrySet()) {
                if (param.getValue() == null || param.getValue().length() <= 0) continue;
                urlBuilder.addParameter(param.getKey(), new Object[]{param.getValue()});
            }
        }
        String url = String.valueOf(pathPrefix) + urlBuilder.toString();
        url = StringUtils.replace((String)url, (String)"+", (String)"%20");
        url = StringUtils.replace((String)url, (String)"%2F", (String)"/");
        url = StringUtils.replace((String)url, (String)"&amp%3B", (String)"&amp;");
        return url;
    }

    @Override
    public void initialize(WikiEngine engine, Properties properties) {
        this.m_engine = engine;
        this.m_pathPrefix = StripesURLConstructor.getContextPath(engine);
        this.m_baseUrl = engine.getBaseURL();
        if (this.m_baseUrl.endsWith("/")) {
            this.m_baseUrl = this.m_baseUrl.substring(0, this.m_baseUrl.length() - 1);
        }
        log.info("StripesURLConstructor initialized.", new Object[0]);
    }

    public static String getContextPath(WikiEngine engine) {
        String baseurl = engine.getBaseURL();
        String contextPath = "/JSPWiki";
        if (baseurl != null && baseurl.length() > 0) {
            try {
                URL url = new URL(baseurl);
                contextPath = url.getPath();
                if (contextPath.endsWith("/")) {
                    contextPath = contextPath.substring(0, contextPath.length() - 1);
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return contextPath;
    }

    private UrlBindingFactory getUrlBindingFactory() {
        Configuration stripesConfig = StripesFilter.getConfiguration();
        if (stripesConfig == null) {
            throw new InternalWikiException("No Stripes configuration found!");
        }
        ActionResolver resolver = stripesConfig.getActionResolver();
        if (resolver instanceof AnnotatedClassActionResolver) {
            return ((AnnotatedClassActionResolver)resolver).getUrlBindingFactory();
        }
        throw new InternalWikiException("Stripes ActionResolver did not have an URLBindingFactory!");
    }

    private Map<String, String> splitParamString(String appendedParams) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (appendedParams != null) {
            String[] kvs;
            String[] stringArray = kvs = appendedParams.split(String.valueOf("&"));
            int n = kvs.length;
            int n2 = 0;
            while (n2 < n) {
                String kv = stringArray[n2];
                int equals = kv.lastIndexOf(61, kv.length() - 1);
                switch (equals) {
                    case 0: {
                        break;
                    }
                    case -1: {
                        params.put(kv, "");
                        break;
                    }
                    default: {
                        String key = kv.substring(0, equals);
                        String value = kv.substring(equals + 1, kv.length());
                        params.put(key, value);
                    }
                }
                ++n2;
            }
        }
        return params;
    }

    /*
     * Unable to fully structure code
     */
    protected static UrlBindingParameter parseUrlBindingParameter(Class<? extends ActionBean> beanClass, String string) {
        chars = string.toCharArray();
        c = '\u0000';
        escape = false;
        name = new StringBuilder();
        defaultValue = new StringBuilder();
        current = name;
        i = 0;
        while (i < chars.length) {
            c = chars[i];
            if (escape) ** GOTO lbl-1000
            switch (c) {
                case '\\': {
                    escape = true;
                    break;
                }
                case '=': {
                    current = defaultValue;
                    break;
                }
                default: lbl-1000:
                // 2 sources

                {
                    current.append(c);
                    escape = false;
                }
            }
            ++i;
        }
        v0 = dflt = defaultValue.length() < 1 ? null : defaultValue.toString();
        if (dflt != null && "$event".equals(name.toString())) {
            throw new ParseException(string, "In ActionBean class " + beanClass.getName() + ", the " + "$event" + " parameter may not be assigned a default value. Its default value is" + " determined by the @DefaultHandler annotation.");
        }
        return new UrlBindingParameter(beanClass, name.toString(), null, dflt){

            public String getValue() {
                throw new UnsupportedOperationException("getValue() is not implemented for URL parameter prototypes");
            }
        };
    }
}

