/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.ui.stripes;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.Locale;
import net.sourceforge.stripes.config.Configuration;
import net.sourceforge.stripes.controller.StripesFilter;
import net.sourceforge.stripes.validation.LocalizableError;
import net.sourceforge.stripes.validation.SimpleError;
import net.sourceforge.stripes.validation.TypeConverter;
import net.sourceforge.stripes.validation.ValidationError;
import org.apache.wiki.InternalWikiException;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.api.WikiPage;
import org.apache.wiki.content.ContentManager;
import org.apache.wiki.content.PageAlreadyExistsException;
import org.apache.wiki.content.PageNotFoundException;
import org.apache.wiki.content.WikiPath;
import org.apache.wiki.providers.ProviderException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WikiPageTypeConverter
implements TypeConverter<WikiPage> {
    public WikiPage convert(String pageName, Class<? extends WikiPage> targetType, Collection<ValidationError> errors) {
        Configuration config = StripesFilter.getConfiguration();
        WikiEngine engine = WikiEngine.getInstance(config.getServletContext(), null);
        WikiPage page = null;
        try {
            String decodedName = URLDecoder.decode(pageName, "UTF-8");
            if (decodedName != null) {
                pageName = decodedName;
            }
        }
        catch (UnsupportedEncodingException e1) {
            throw new InternalWikiException("Impossible! UTF-8 must be supported.");
        }
        URI uri = engine.getSpecialPageReference(pageName);
        if (uri != null) {
            errors.add((ValidationError)new LocalizableError("edit.specialPage", new Object[0]));
            return null;
        }
        try {
            page = engine.getPage(pageName);
        }
        catch (PageNotFoundException e) {
            try {
                page = this.getFinalPage(engine, pageName);
                if (page == null) {
                    ContentManager cm = engine.getContentManager();
                    page = cm.addPage(WikiPath.valueOf(pageName), "text/x-jspwiki");
                    cm.release();
                }
            }
            catch (PageAlreadyExistsException e2) {
                errors.add((ValidationError)new SimpleError(e2.getMessage(), new Object[0]));
            }
            catch (ProviderException e2) {
                errors.add((ValidationError)new SimpleError(e2.getMessage(), new Object[0]));
            }
        }
        catch (ProviderException e) {
            errors.add((ValidationError)new SimpleError("Provider exception: " + e.getMessage(), new Object[0]));
        }
        return page;
    }

    private WikiPage getFinalPage(WikiEngine engine, String pageName) throws ProviderException {
        WikiPath finalName = engine.getFinalPageName(WikiPath.valueOf(pageName));
        if (finalName != null) {
            try {
                return engine.getPage(finalName);
            }
            catch (PageNotFoundException pnf) {
                pnf.printStackTrace();
                throw new ProviderException("Could not find WikiPage " + finalName + " even though we just found it. Odd!");
            }
        }
        return null;
    }

    public void setLocale(Locale locale) {
    }
}

