/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.ui.stripes;

import java.lang.reflect.Method;
import java.security.Permission;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.RedirectResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.controller.DispatcherHelper;
import net.sourceforge.stripes.controller.ExecutionContext;
import net.sourceforge.stripes.controller.Interceptor;
import net.sourceforge.stripes.controller.Intercepts;
import net.sourceforge.stripes.controller.LifecycleStage;
import net.sourceforge.stripes.validation.ValidationErrors;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.WikiSession;
import org.apache.wiki.action.InstallActionBean;
import org.apache.wiki.action.LoginActionBean;
import org.apache.wiki.action.ViewActionBean;
import org.apache.wiki.action.WikiActionBean;
import org.apache.wiki.action.WikiContextFactory;
import org.apache.wiki.api.WikiException;
import org.apache.wiki.auth.AuthorizationManager;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.apache.wiki.ui.TemplateManager;
import org.apache.wiki.ui.stripes.AjaxEvent;
import org.apache.wiki.ui.stripes.AjaxResolution;
import org.apache.wiki.ui.stripes.HandlerInfo;
import org.apache.wiki.ui.stripes.WikiActionBeanContext;
import org.slf4j.MDC;

@Intercepts(value={LifecycleStage.RequestInit, LifecycleStage.ActionBeanResolution, LifecycleStage.HandlerResolution, LifecycleStage.CustomValidation, LifecycleStage.RequestComplete})
public class WikiInterceptor
implements Interceptor {
    private boolean m_isConfigured = false;
    private static final Logger log = LoggerFactory.getLogger(WikiInterceptor.class);
    public static final String ATTR_ACTIONBEAN = "wikiActionBean";

    public Resolution intercept(ExecutionContext context) throws Exception {
        switch (context.getLifecycleStage()) {
            case RequestInit: {
                HttpServletRequest request = context.getActionBeanContext().getRequest();
                HttpServletResponse response = context.getActionBeanContext().getResponse();
                response.addHeader("X-FRAME-OPTIONS", "DENY");
                WikiEngine engine = ((WikiActionBeanContext)context.getActionBeanContext()).getEngine();
                MDC.put((String)(String.valueOf(engine.getApplicationName()) + ":" + request.getRequestURI()), (String)"WikiInterceptor");
                break;
            }
            case ActionBeanResolution: {
                return this.interceptAfterActionBeanResolution(context);
            }
            case HandlerResolution: {
                return this.interceptAfterHandlerResolution(context);
            }
            case CustomValidation: {
                return this.interceptAfterBindingAndValidation(context);
            }
            case RequestComplete: {
                HttpServletRequest request = context.getActionBeanContext().getRequest();
                WikiEngine engine = ((WikiActionBeanContext)context.getActionBeanContext()).getEngine();
                MDC.remove((String)(String.valueOf(engine.getApplicationName()) + ":" + request.getRequestURI()));
            }
        }
        return null;
    }

    protected Resolution interceptAfterHandlerResolution(ExecutionContext context) throws Exception {
        Resolution r = context.proceed();
        if (r != null) {
            return r;
        }
        Method handler = context.getHandler();
        WikiActionBean actionBean = (WikiActionBean)context.getActionBean();
        Map<Method, HandlerInfo> eventinfos = HandlerInfo.getHandlerInfoCollection(actionBean.getClass());
        HandlerInfo eventInfo = eventinfos.get(handler);
        if (eventInfo != null) {
            String requestContext = eventInfo.getRequestContext();
            actionBean.getContext().setRequestContext(requestContext);
        }
        if (actionBean instanceof ViewActionBean) {
            WikiEngine engine = actionBean.getContext().getEngine();
            ((ViewActionBean)actionBean).setPage(engine.getFrontPage(null));
        }
        if ((r = this.checkConfiguration(context)) != null) {
            return r;
        }
        return null;
    }

    protected Resolution checkConfiguration(ExecutionContext context) throws Exception {
        ActionBean actionBean = context.getActionBean();
        if (this.m_isConfigured) {
            if (actionBean instanceof InstallActionBean) {
                return new RedirectResolution(LoginActionBean.class);
            }
            return null;
        }
        if (actionBean instanceof InstallActionBean) {
            return null;
        }
        ServletContext servletContext = context.getActionBeanContext().getServletContext();
        WikiEngine engine = WikiEngine.getInstance(servletContext, null);
        Properties props = engine.getWikiProperties();
        boolean hasBaseUrl = this.isPropertySet("jspwiki.baseURL", props);
        boolean hasAdminPassword = this.isPropertySet("admin.passwordHash", props);
        if (!hasBaseUrl || !hasAdminPassword) {
            return new RedirectResolution(InstallActionBean.class);
        }
        this.m_isConfigured = true;
        return null;
    }

    private boolean isPropertySet(String name, Properties props) {
        String value = props.getProperty(name);
        return value != null && value.length() > 0;
    }

    protected Resolution interceptAfterActionBeanResolution(ExecutionContext context) throws Exception {
        Resolution r = context.proceed();
        if (r != null) {
            return r;
        }
        WikiActionBean actionBean = (WikiActionBean)context.getActionBean();
        WikiActionBeanContext actionBeanContext = actionBean.getContext();
        HttpServletRequest request = actionBeanContext.getRequest();
        if (actionBeanContext.getWikiSession() == null) {
            throw new WikiException("No WikiSession found!");
        }
        WikiEngine engine = actionBeanContext.getEngine();
        engine.getAuthenticationManager().login(request);
        request.setAttribute(ATTR_ACTIONBEAN, (Object)actionBean);
        PageContext pageContext = DispatcherHelper.getPageContext();
        if (pageContext != null) {
            pageContext.setAttribute(ATTR_ACTIONBEAN, (Object)actionBean);
        }
        WikiContextFactory.saveContext((ServletRequest)request, actionBean.getContext());
        String templateString = TemplateManager.getTemplateJSStrings(request.getSession(), request.getLocale());
        request.getSession().setAttribute("templateJsStrings", (Object)templateString);
        if (log.isDebugEnabled()) {
            log.debug("WikiInterceptor resolved ActionBean: " + actionBean, new Object[0]);
        }
        return null;
    }

    protected Resolution interceptAfterBindingAndValidation(ExecutionContext context) throws Exception {
        Permission requiredPermission;
        Resolution r = context.proceed();
        if (r != null) {
            return r;
        }
        ActionBeanContext actionBeanContext = context.getActionBeanContext();
        ValidationErrors errors = actionBeanContext.getValidationErrors();
        Method handler = context.getHandler();
        if (handler.getAnnotation(AjaxEvent.class) != null && errors.size() > 0) {
            return new AjaxResolution(actionBeanContext);
        }
        WikiActionBean actionBean = (WikiActionBean)context.getActionBean();
        Map<Method, HandlerInfo> eventinfos = HandlerInfo.getHandlerInfoCollection(actionBean.getClass());
        HandlerInfo eventInfo = eventinfos.get(handler);
        boolean allowed = true;
        if (eventInfo != null && (requiredPermission = eventInfo.getPermission(actionBean)) != null) {
            WikiEngine engine = actionBean.getContext().getEngine();
            AuthorizationManager mgr = engine.getAuthorizationManager();
            WikiSession wikiSession = actionBean.getContext().getWikiSession();
            allowed = mgr.checkPermission(wikiSession, requiredPermission);
        }
        if (!allowed) {
            r = new RedirectResolution(LoginActionBean.class);
            ((RedirectResolution)r).includeRequestParameters(true);
            if (log.isDebugEnabled()) {
                log.debug("WikiInterceptor rejected access to ActionBean=" + actionBean.getClass().getCanonicalName() + ", method=" + handler.getName(), new Object[0]);
            }
            return r;
        }
        return null;
    }

    public static WikiActionBean findActionBean(PageContext pageContext) {
        WikiActionBean bean = (WikiActionBean)pageContext.getAttribute(ATTR_ACTIONBEAN);
        if (bean == null && (bean = WikiInterceptor.findActionBean(pageContext.getRequest())) == null) {
            log.debug("WikiActionBean not found under page context attribute 'wikiActionBean'! Something failed to stash it...", new Object[0]);
        }
        return bean;
    }

    public static WikiActionBean findActionBean(ServletRequest request) {
        WikiActionBean bean = (WikiActionBean)request.getAttribute(ATTR_ACTIONBEAN);
        if (bean == null) {
            log.debug("WikiActionBean not found under request attribute 'wikiActionBean'! Something failed to stash it...", new Object[0]);
            bean = (WikiActionBean)request.getAttribute(ATTR_ACTIONBEAN);
        }
        return bean;
    }
}

