/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.ui.stripes;

import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TimeZone;
import net.sourceforge.stripes.format.Formatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeZoneFormatter
implements Formatter<TimeZone> {
    private Locale m_locale = null;
    private String m_formatType = null;
    public static final String LOCALIZED = "localized";
    public static final String ID = "id";
    public static final String I18NSERVER_TIMEZONE = "prefs.user.timezone.server";

    public String format(TimeZone zone) {
        if (this.m_formatType == null) {
            this.m_formatType = LOCALIZED;
        }
        if (LOCALIZED.equals(this.m_formatType)) {
            TimeZone serverZone = TimeZone.getDefault();
            Date now = new Date();
            int offset = zone.getRawOffset() / 3600000;
            String zoneLabel = "[GMT" + (offset > 0 ? "+" : "") + offset + "] " + zone.getDisplayName(zone.inDaylightTime(now), 1, this.m_locale);
            if (serverZone.getRawOffset() == zone.getRawOffset()) {
                ResourceBundle b = ResourceBundle.getBundle("templates.default", this.m_locale);
                String serverLabel = b.getString(I18NSERVER_TIMEZONE);
                zoneLabel = String.valueOf(zoneLabel) + " " + serverLabel;
            }
            return zoneLabel;
        }
        if (ID.equals(this.m_formatType)) {
            return zone.getID();
        }
        return zone.toString();
    }

    public void init() {
    }

    public void setFormatPattern(String formatPattern) {
    }

    public void setFormatType(String formatType) {
        this.m_formatType = formatType;
    }

    public void setLocale(Locale locale) {
        this.m_locale = locale;
    }
}

