/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.ui.stripes;

import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sourceforge.stripes.action.OnwardResolution;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.apache.wiki.ui.TemplateManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateResolution
extends OnwardResolution<TemplateResolution> {
    private static final Logger LOG = LoggerFactory.getLogger(TemplateResolution.class);
    private static final String DEFAULT_PATH_PREFIX = "/templates/default/";

    public TemplateResolution(String resource) {
        super(resource);
    }

    public void execute(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ServletContext servletContext = request.getSession().getServletContext();
        String path = TemplateManager.getResourceResolver(servletContext).get(this.getPath());
        if (path == null) {
            path = DEFAULT_PATH_PREFIX + this.getPath();
        }
        this.setPath(path);
        LOG.debug("Forwarding user to resolved template resource: " + path, new Object[0]);
        String url = this.getUrl(request.getLocale());
        request.getRequestDispatcher(url).forward((ServletRequest)request, (ServletResponse)response);
    }
}

