/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.ui.stripes;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.controller.ExecutionContext;
import net.sourceforge.stripes.controller.Interceptor;
import net.sourceforge.stripes.controller.Intercepts;
import net.sourceforge.stripes.controller.LifecycleStage;
import net.sourceforge.stripes.util.CryptoUtil;
import net.sourceforge.stripes.util.bean.NoSuchPropertyException;
import net.sourceforge.stripes.util.bean.PropertyExpression;
import net.sourceforge.stripes.util.bean.PropertyExpressionEvaluation;
import net.sourceforge.stripes.validation.LocalizableError;
import net.sourceforge.stripes.validation.ValidationError;
import org.apache.commons.jrcs.diff.DifferentiationFailedException;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.action.WikiActionBean;
import org.apache.wiki.api.WikiException;
import org.apache.wiki.content.inspect.Captcha;
import org.apache.wiki.content.inspect.Challenge;
import org.apache.wiki.content.inspect.Change;
import org.apache.wiki.content.inspect.Inspection;
import org.apache.wiki.content.inspect.PasswordChallenge;
import org.apache.wiki.content.inspect.SpamInspectionPlan;
import org.apache.wiki.content.inspect.Topic;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.apache.wiki.ui.stripes.HandlerInfo;
import org.apache.wiki.ui.stripes.WikiActionBeanContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Intercepts(value={LifecycleStage.EventHandling})
public class SpamInterceptor
implements Interceptor {
    public static final String CHALLENGE_REQUEST_PARAM = "_cn";
    public static final String SPAM_VALIDATION_ERROR = "validation.challenge.required";
    private static final Logger log = LoggerFactory.getLogger(SpamInterceptor.class);
    private static final Challenge PASSWORD_CHALLENGE = new PasswordChallenge();

    protected static Map<String, Object> getBeanProperties(WikiActionBean actionBean, String[] beanProperties) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String[] stringArray = beanProperties;
        int n = beanProperties.length;
        int n2 = 0;
        while (n2 < n) {
            String beanProperty = stringArray[n2];
            try {
                PropertyExpression propExpression = PropertyExpression.getExpression((String)beanProperty);
                PropertyExpressionEvaluation evaluation = new PropertyExpressionEvaluation(propExpression, (Object)actionBean);
                Object value = evaluation.getValue();
                if (value == null) {
                    value = "";
                }
                map.put(beanProperty, value);
            }
            catch (NoSuchPropertyException noSuchPropertyException) {
                // empty catch block
            }
            ++n2;
        }
        return map;
    }

    public Resolution intercept(ExecutionContext context) throws Exception {
        HandlerInfo eventInfo = this.getHandlerInfo(context);
        if (!eventInfo.isSpamProtected()) {
            return context.proceed();
        }
        WikiActionBean actionBean = (WikiActionBean)context.getActionBean();
        boolean isSpam = false;
        switch (this.getChallengeState(actionBean.getContext())) {
            case CHALLENGE_NOT_PRESENTED: {
                isSpam = this.checkForSpam(actionBean, eventInfo);
                break;
            }
            case PASSWORD_PRESENTED: {
                this.checkForSpam(actionBean, eventInfo);
                if (PASSWORD_CHALLENGE.check(actionBean.getContext())) break;
                LocalizableError error = new LocalizableError("login.error.password", new Object[0]);
                actionBean.getContext().getValidationErrors().addGlobalError((ValidationError)error);
                return actionBean.getContext().getSourcePageResolution();
            }
            case CAPTCHA_PRESENTED: {
                this.checkForSpam(actionBean, eventInfo);
                WikiEngine engine = actionBean.getContext().getEngine();
                SpamInspectionPlan plan = SpamInspectionPlan.getInspectionPlan(engine);
                Captcha captcha = plan.getCaptcha();
                isSpam = !captcha.check(actionBean.getContext());
                break;
            }
            case MISSING_STATE: {
                this.checkForSpam(actionBean, eventInfo);
                isSpam = true;
            }
        }
        if (isSpam) {
            LocalizableError error = new LocalizableError(SPAM_VALIDATION_ERROR, new Object[0]);
            actionBean.getContext().getValidationErrors().addGlobalError((ValidationError)error);
            return actionBean.getContext().getSourcePageResolution();
        }
        return context.proceed();
    }

    private Challenge.State getChallengeState(ActionBeanContext actionBeanContext) {
        String captchaParam;
        HttpServletRequest request = actionBeanContext.getRequest();
        String encryptedCaptchaParam = request.getParameter(CHALLENGE_REQUEST_PARAM);
        if (encryptedCaptchaParam != null && (captchaParam = CryptoUtil.decrypt((String)encryptedCaptchaParam)) != null) {
            try {
                Challenge.State challenge = Challenge.State.valueOf(captchaParam);
                return challenge;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return Challenge.State.MISSING_STATE;
    }

    private HandlerInfo getHandlerInfo(ExecutionContext context) throws WikiException {
        Method handler = context.getHandler();
        WikiActionBean actionBean = (WikiActionBean)context.getActionBean();
        Map<Method, HandlerInfo> eventinfos = HandlerInfo.getHandlerInfoCollection(actionBean.getClass());
        HandlerInfo eventInfo = eventinfos.get(handler);
        if (eventInfo == null) {
            String message = "Event handler method " + actionBean.getClass().getName() + "#" + handler.getName() + " does not have an associated HandlerInfo object. This should not happen.";
            log.error(message, new Object[0]);
            throw new WikiException(message);
        }
        return eventInfo;
    }

    protected boolean checkForSpam(WikiActionBean actionBean, HandlerInfo eventInfo) throws DifferentiationFailedException, WikiException {
        WikiActionBeanContext actionBeanContext = actionBean.getContext();
        WikiEngine engine = actionBeanContext.getEngine();
        SpamInspectionPlan plan = SpamInspectionPlan.getInspectionPlan(engine);
        Map<String, Object> fieldValues = SpamInterceptor.getBeanProperties(actionBean, eventInfo.getSpamProtectedFields());
        Inspection inspection = new Inspection(actionBeanContext, plan);
        ArrayList<Change> changes = new ArrayList<Change>();
        for (Map.Entry<String, Object> entry : fieldValues.entrySet()) {
            String field = entry.getKey();
            String value = entry.getValue().toString();
            Change change = "page".equals(field) ? Change.getPageChange(actionBeanContext, value) : Change.getChange(field, value);
            changes.add(change);
        }
        inspection.inspect(changes.toArray(new Change[changes.size()]));
        float spamScore = inspection.getScore(Topic.SPAM);
        return spamScore <= plan.getSpamLimit();
    }
}

