/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.ui.stripes;

import java.io.IOException;
import java.util.Properties;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sourceforge.stripes.action.RedirectResolution;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.action.ViewActionBean;
import org.apache.wiki.ui.stripes.HandlerInfo;
import org.apache.wiki.util.TextUtil;

public class ShortUrlFilter
implements Filter {
    private String m_urlPrefix = null;
    private String m_urlPrefixNoTrailingSlash = null;
    private WikiEngine m_engine = null;
    private boolean m_initialized = false;
    public static final String PROP_PREFIX = "jspwiki.shortURLConstructor.prefix";
    private static final String DEFAULT_PREFIX = "wiki/";

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!this.m_initialized) {
            this.lazyInit(((HttpServletRequest)request).getSession().getServletContext());
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String uri = httpRequest.getRequestURI();
        if (this.m_urlPrefix.equals(uri) || this.m_urlPrefixNoTrailingSlash.equals(uri)) {
            new RedirectResolution(ViewActionBean.class).execute(httpRequest, httpResponse);
            return;
        }
        if (!uri.startsWith(this.m_urlPrefix)) {
            chain.doFilter(request, response);
            return;
        }
        String requestContext = request.getParameter("do");
        if (requestContext == null) {
            requestContext = WikiContext.VIEW;
        }
        requestContext = requestContext.toLowerCase();
        String wikiPath = uri.substring(this.m_urlPrefix.length(), uri.length());
        if (wikiPath.length() == 0) {
            wikiPath = null;
        }
        HandlerInfo handler = this.m_engine.getWikiContextFactory().findEventHandler(requestContext);
        RedirectResolution r = new RedirectResolution(handler.getActionBeanClass(), handler.getEventName());
        if (wikiPath != null) {
            r.addParameter("page", new Object[]{wikiPath});
        }
        r.execute(httpRequest, (HttpServletResponse)response);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    private void lazyInit(ServletContext servletContext) {
        WikiEngine engine;
        this.m_engine = engine = WikiEngine.getInstance(servletContext, null);
        Properties props = engine.getWikiProperties();
        this.m_urlPrefix = TextUtil.getStringProperty(props, PROP_PREFIX, DEFAULT_PREFIX);
        if (this.m_urlPrefix == null) {
            this.m_urlPrefix = DEFAULT_PREFIX;
        }
        if (!this.m_urlPrefix.startsWith("/")) {
            this.m_urlPrefix = "/" + this.m_urlPrefix;
        }
        if (!this.m_urlPrefix.endsWith("/")) {
            this.m_urlPrefix = String.valueOf(this.m_urlPrefix) + "/";
        }
        this.m_urlPrefix = "/" + servletContext.getServletContextName() + this.m_urlPrefix;
        this.m_urlPrefixNoTrailingSlash = this.m_urlPrefix.substring(0, this.m_urlPrefix.length() - 1);
        this.m_initialized = true;
    }
}

