/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.ui.stripes;

import java.util.Collection;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import net.sourceforge.stripes.config.Configuration;
import net.sourceforge.stripes.localization.LocalePicker;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.preferences.Preferences;
import org.apache.wiki.ui.stripes.LocaleConverter;

public class PreferencesLocalePicker
implements LocalePicker {
    private static final LocaleConverter LOCALE_CONVERTER = new LocaleConverter();
    private static final String COOKIE_LOCALE = "Locale";

    public void init(Configuration configuration) throws Exception {
    }

    public String pickCharacterEncoding(HttpServletRequest request, Locale locale) {
        return "UTF-8";
    }

    public Locale pickLocale(HttpServletRequest request) {
        Object match;
        Locale closestMatch;
        Object locale = null;
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            Cookie[] cookieArray = request.getCookies();
            int n = cookieArray.length;
            int n2 = 0;
            while (n2 < n) {
                Cookie cookie = cookieArray[n2];
                if (COOKIE_LOCALE.equals(cookie.getName())) {
                    locale = LOCALE_CONVERTER.convert(cookie.getValue(), Locale.class, (Collection)null);
                    break;
                }
                ++n2;
            }
        }
        if (locale == null) {
            locale = request.getLocale();
        }
        if ((closestMatch = this.isSupported(((Locale)locale).getLanguage(), null, null)) != null) {
            match = closestMatch;
            closestMatch = this.isSupported(((Locale)locale).getLanguage(), ((Locale)locale).getCountry(), null);
            if (closestMatch != null) {
                match = closestMatch;
                closestMatch = this.isSupported(((Locale)locale).getLanguage(), ((Locale)locale).getCountry(), ((Locale)locale).getVariant());
                if (closestMatch != null) {
                    match = closestMatch;
                }
            }
        } else {
            WikiEngine engine = WikiEngine.getInstance(request.getSession().getServletContext(), null);
            Properties props = engine.getWikiProperties();
            String defaultPref = props.getProperty("jspwiki.defaultprefs.template.language", Locale.getDefault().toString());
            match = LOCALE_CONVERTER.convert(defaultPref, Locale.class, (Collection)null);
        }
        Preferences prefs = Preferences.getPreferences(request);
        prefs.put(COOKIE_LOCALE, match);
        return match;
    }

    private boolean isEqual(String a, String b) {
        if (a == null) {
            a = "";
        }
        if (b == null) {
            b = "";
        }
        return a.equals(b);
    }

    private Locale isSupported(String language, String country, String variant) {
        for (Locale locale : Preferences.AVAILABLE_LOCALES.keySet()) {
            boolean languageMatch = this.isEqual(language, locale.getLanguage());
            boolean countryMatch = this.isEqual(country, locale.getCountry());
            boolean variantMatch = this.isEqual(variant, locale.getVariant());
            if (!languageMatch || !countryMatch || !variantMatch) continue;
            return locale;
        }
        return null;
    }
}

