/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.ui.stripes;

import java.lang.annotation.AnnotationFormatError;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.Permission;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.jsp.el.ELException;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.HandlesEvent;
import net.sourceforge.stripes.util.bean.EvaluationException;
import net.sourceforge.stripes.util.bean.PropertyExpression;
import net.sourceforge.stripes.util.bean.PropertyExpressionEvaluation;
import org.apache.wiki.auth.permissions.PagePermission;
import org.apache.wiki.auth.permissions.PermissionFactory;
import org.apache.wiki.ui.stripes.HandlerPermission;
import org.apache.wiki.ui.stripes.SpamProtect;
import org.apache.wiki.ui.stripes.WikiRequestContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandlerInfo {
    private static final Map<Class<? extends ActionBean>, Map<Method, HandlerInfo>> CACHED_INFO = new HashMap<Class<? extends ActionBean>, Map<Method, HandlerInfo>>();
    private final Class<? extends ActionBean> m_beanClass;
    private final Method m_handlerMethod;
    private final Class<? extends Permission> m_permissionClass;
    private final String m_permissionTarget;
    private final String m_permissionActions;
    private final String m_handlerName;
    private final PropertyExpression m_permissionTargetExpression;
    private final PropertyExpression m_permissionActionExpression;
    private final String m_requestContext;
    private final boolean m_spamProtected;
    private final String[] m_spamProtectedFields;

    private HandlerInfo(Class<? extends ActionBean> beanClass, Method method, String eventHandler) {
        Class<? extends Permission> permClass = null;
        String target = null;
        String actions = null;
        HandlerPermission permAnnotation = method.getAnnotation(HandlerPermission.class);
        if (permAnnotation != null) {
            permClass = permAnnotation.permissionClass();
            target = permAnnotation.target();
            actions = permAnnotation.actions();
            if (permClass == null || target == null) {
                throw new AnnotationFormatError("Malformed annotation: " + method.getClass().getName() + "." + method.getName());
            }
        }
        this.m_beanClass = beanClass;
        this.m_handlerMethod = method;
        this.m_permissionClass = permClass;
        this.m_permissionTarget = target == null || "".equals(target) ? null : target;
        this.m_permissionActions = actions == null || "".equals(actions) ? null : actions;
        this.m_permissionTargetExpression = target != null && target.startsWith("${") && target.endsWith("}") ? PropertyExpression.getExpression((String)target.substring(2, target.length() - 1)) : null;
        this.m_permissionActionExpression = actions != null && actions.startsWith("${") && actions.endsWith("}") ? PropertyExpression.getExpression((String)this.m_permissionTarget.substring(2, this.m_permissionTarget.length() - 1)) : null;
        WikiRequestContext requestContext = method.getAnnotation(WikiRequestContext.class);
        String defaultRequestContext = String.valueOf(this.m_beanClass.getName()) + "." + eventHandler;
        this.m_requestContext = requestContext != null ? requestContext.value() : defaultRequestContext;
        SpamProtect spam = method.getAnnotation(SpamProtect.class);
        this.m_spamProtected = spam != null;
        this.m_spamProtectedFields = spam == null ? new String[]{} : spam.content();
        this.m_handlerName = eventHandler;
    }

    protected String getPermissionActions() {
        return this.m_permissionActions;
    }

    protected Class<? extends Permission> getPermissionClass() {
        return this.m_permissionClass;
    }

    protected String getPermissionTarget() {
        return this.m_permissionTarget;
    }

    protected PropertyExpression getPermissionTargetExpression() {
        return this.m_permissionTargetExpression;
    }

    protected PropertyExpression getActionsExpression() {
        return this.m_permissionActionExpression;
    }

    public static final HandlerInfo getDefaultHandlerInfo(Class<? extends ActionBean> beanClass) {
        Map<Method, HandlerInfo> eventInfoCollection = CACHED_INFO.get(beanClass);
        if (eventInfoCollection == null) {
            throw new IllegalArgumentException("Bean class " + beanClass.getCanonicalName() + " does not have cached event info.");
        }
        for (Map.Entry<Method, HandlerInfo> methodEvent : eventInfoCollection.entrySet()) {
            Method method = methodEvent.getKey();
            HandlerInfo handlerInfo = methodEvent.getValue();
            if (method.getAnnotation(DefaultHandler.class) == null) continue;
            return handlerInfo;
        }
        throw new IllegalArgumentException("Bean class " + beanClass.getCanonicalName() + " has no @DefaultHandler!");
    }

    public static final HandlerInfo getHandlerInfo(Class<? extends ActionBean> beanClass, String eventHandler) {
        Collection<HandlerInfo> handlerInfos = HandlerInfo.getHandlerInfoCollection(beanClass).values();
        for (HandlerInfo handlerInfo : handlerInfos) {
            if (!eventHandler.equals(handlerInfo.getEventName())) continue;
            return handlerInfo;
        }
        throw new IllegalArgumentException("ActionBean=" + beanClass.getCanonicalName() + ", handler=" + eventHandler + " has no HandlerInfo!");
    }

    public static final Map<Method, HandlerInfo> getHandlerInfoCollection(Class<? extends ActionBean> beanClass) {
        Map<Method, HandlerInfo> eventInfoCollection = CACHED_INFO.get(beanClass);
        if (eventInfoCollection != null) {
            return eventInfoCollection;
        }
        eventInfoCollection = new HashMap<Method, HandlerInfo>();
        CACHED_INFO.put(beanClass, eventInfoCollection);
        Method[] methods = beanClass.getMethods();
        int i = 0;
        while (i < methods.length) {
            Method method = methods[i];
            HandlesEvent eventAnnotation = method.getAnnotation(HandlesEvent.class);
            if (eventAnnotation != null) {
                HandlerInfo handlerInfo = new HandlerInfo(beanClass, method, eventAnnotation.value());
                eventInfoCollection.put(method, handlerInfo);
            }
            ++i;
        }
        return eventInfoCollection;
    }

    public Class<? extends ActionBean> getActionBeanClass() {
        return this.m_beanClass;
    }

    public Method getHandlerMethod() {
        return this.m_handlerMethod;
    }

    public String getEventName() {
        return this.m_handlerName;
    }

    public String getRequestContext() {
        return this.m_requestContext;
    }

    public Permission getPermission(Object object) throws ELException {
        PropertyExpressionEvaluation evaluation;
        if (this.m_permissionClass == null) {
            return null;
        }
        boolean hasOneParameter = this.m_permissionActions == null;
        String target = this.m_permissionTarget;
        String actions = this.m_permissionActions;
        if (this.m_permissionTargetExpression != null) {
            evaluation = new PropertyExpressionEvaluation(this.m_permissionTargetExpression, object);
            Object value = null;
            try {
                value = evaluation.getValue();
            }
            catch (EvaluationException evaluationException) {
                // empty catch block
            }
            if (value != null) {
                target = value.toString();
            }
            if (value == null || target == null) {
                return null;
            }
        }
        if (this.m_permissionActionExpression != null && (actions = (String)(evaluation = new PropertyExpressionEvaluation(this.m_permissionActionExpression, object)).getValue()) == null) {
            throw new ELException("Actions expression '${" + this.m_permissionTargetExpression + "} ' returned null!");
        }
        Permission perm = null;
        if (PagePermission.class.isAssignableFrom(this.m_permissionClass)) {
            return PermissionFactory.getPagePermission(target, actions);
        }
        try {
            Constructor<? extends Permission> c;
            if (hasOneParameter) {
                c = this.m_permissionClass.getConstructor(String.class);
                perm = c.newInstance(target);
            } else {
                c = this.m_permissionClass.getConstructor(String.class, String.class);
                perm = c.newInstance(target, actions);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ELException("Could not evaluate permission info: " + e.getMessage());
        }
        return perm;
    }

    public String[] getSpamProtectedFields() {
        return this.m_spamProtectedFields;
    }

    public boolean isSpamProtected() {
        return this.m_spamProtected;
    }
}

