/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.ui.stripes;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.Locale;
import net.sourceforge.stripes.config.Configuration;
import net.sourceforge.stripes.controller.StripesFilter;
import net.sourceforge.stripes.validation.LocalizableError;
import net.sourceforge.stripes.validation.TypeConverter;
import net.sourceforge.stripes.validation.ValidationError;
import org.apache.wiki.InternalWikiException;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.auth.NoSuchPrincipalException;
import org.apache.wiki.auth.WikiSecurityException;
import org.apache.wiki.auth.authorize.Group;
import org.apache.wiki.auth.authorize.GroupManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupTypeConverter
implements TypeConverter<Group> {
    public Group convert(String groupName, Class<? extends Group> targetType, Collection<ValidationError> errors) {
        Configuration config = StripesFilter.getConfiguration();
        WikiEngine engine = WikiEngine.getInstance(config.getServletContext(), null);
        GroupManager mgr = engine.getGroupManager();
        try {
            String decodedName = URLDecoder.decode(groupName, "UTF-8");
            if (decodedName != null) {
                groupName = decodedName;
            }
        }
        catch (UnsupportedEncodingException e1) {
            throw new InternalWikiException("Impossible! UTF-8 must be supported.");
        }
        Group group = null;
        try {
            group = mgr.getGroup(groupName, true);
        }
        catch (NoSuchPrincipalException noSuchPrincipalException) {
        }
        catch (WikiSecurityException e) {
            errors.add((ValidationError)new LocalizableError("editgroup.illegalname", new Object[0]));
        }
        return group;
    }

    public void setLocale(Locale locale) {
    }
}

