/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.ui.stripes;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.config.Configuration;
import net.sourceforge.stripes.config.DontAutoLoad;
import net.sourceforge.stripes.controller.NameBasedActionResolver;
import net.sourceforge.stripes.controller.UrlBinding;
import net.sourceforge.stripes.controller.UrlBindingFactory;
import org.apache.wiki.api.WikiException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DontAutoLoad
public class FileBasedActionResolver
extends NameBasedActionResolver {
    private Set<Class<? extends ActionBean>> m_processed = new HashSet<Class<? extends ActionBean>>();
    private Properties m_urlBindings = new Properties();
    private static final String URL_BINDINGS = "/WEB-INF/urlpattern.properties";

    public void init(Configuration configuration) throws Exception {
        this.m_urlBindings.clear();
        InputStream in = configuration.getServletContext().getResourceAsStream(URL_BINDINGS);
        if (in == null) {
            throw new IOException("Resource not returned by servlet context: /WEB-INF/urlpattern.properties");
        }
        try {
            this.m_urlBindings.load(in);
            in.close();
        }
        catch (IOException e) {
            throw new WikiException("Could not find file /WEB-INF/urlpattern.properties. Reason: " + e.getMessage(), e);
        }
        super.init(configuration);
    }

    public String getUrlBinding(Class<? extends ActionBean> clazz) {
        if (this.m_processed.contains(clazz)) {
            return super.getUrlBinding(clazz);
        }
        String binding = this.m_urlBindings.getProperty(clazz.getName());
        if (binding == null) {
            return super.getUrlBinding(clazz);
        }
        UrlBinding prototype = UrlBindingFactory.parseUrlBinding(clazz, (String)binding);
        UrlBindingFactory factory = super.getUrlBindingFactory();
        factory.addBinding(clazz, prototype);
        this.m_processed.add(clazz);
        return prototype.toString();
    }
}

