/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.ui.stripes;

import java.security.Principal;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.WikiSession;
import org.apache.wiki.api.WikiPage;
import org.apache.wiki.auth.SessionMonitor;
import org.apache.wiki.auth.WikiPrincipal;
import org.apache.wiki.auth.permissions.AllPermission;

public class DefaultWikiContext
implements WikiContext {
    private WikiPage m_page;
    private WikiPage m_realPage;
    private WikiEngine m_engine;
    private String m_template = "default";
    private HashMap<String, Object> m_variableMap = new HashMap();
    private String m_requestContext = "none";
    private WikiSession m_session = null;
    protected HttpServletRequest m_request = null;

    public Object clone() {
        try {
            DefaultWikiContext copy = (DefaultWikiContext)super.clone();
            copy.m_engine = this.m_engine;
            copy.m_template = this.m_template;
            copy.m_variableMap = this.m_variableMap;
            copy.m_request = this.m_request;
            copy.m_session = this.m_session;
            copy.m_page = this.m_page;
            copy.m_realPage = this.m_realPage;
            return copy;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public WikiContext deepClone() {
        try {
            DefaultWikiContext copy = (DefaultWikiContext)super.clone();
            copy.m_engine = this.m_engine;
            copy.m_template = this.m_template;
            copy.m_variableMap = (HashMap)this.m_variableMap.clone();
            copy.m_request = this.m_request;
            copy.m_session = this.m_session;
            copy.m_page = this.m_page == null ? null : (WikiPage)this.m_page.clone();
            copy.m_realPage = this.m_realPage == null ? null : (WikiPage)this.m_realPage.clone();
            return copy;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public ResourceBundle getBundle(String bundle) throws MissingResourceException {
        Locale loc = this.getHttpRequest().getLocale();
        ResourceBundle b = this.m_engine.getInternationalizationManager().getBundle(bundle, loc);
        return b;
    }

    public Principal getCurrentUser() {
        if (this.m_session == null) {
            return WikiPrincipal.GUEST;
        }
        return this.m_session.getUserPrincipal();
    }

    public WikiEngine getEngine() {
        return this.m_engine;
    }

    public String getHttpParameter(String paramName) {
        String result = null;
        if (this.m_request != null) {
            result = this.m_request.getParameter(paramName);
        }
        return result;
    }

    public HttpServletRequest getHttpRequest() {
        return this.m_request;
    }

    public WikiPage getPage() {
        return this.m_page;
    }

    public WikiPage getRealPage() {
        return this.m_realPage;
    }

    public String getRequestContext() {
        return this.m_requestContext;
    }

    public String getTemplate() {
        return this.m_template;
    }

    public String getURL(String context, String page) {
        return this.getURL(context, page, null);
    }

    public String getURL(String context, String page, String params) {
        boolean absolute = "absolute".equals(this.m_engine.getVariable(this, "jspwiki.referenceStyle"));
        return this.m_engine.getURL(context, page, params, absolute);
    }

    public Object getVariable(String key) {
        return this.m_variableMap.get(key);
    }

    public String getViewURL(String page) {
        return this.getURL(VIEW, page, null);
    }

    public WikiSession getWikiSession() {
        return this.m_session;
    }

    public boolean hasAdminPermissions() {
        boolean admin = false;
        WikiEngine engine = this.getEngine();
        admin = engine.getAuthorizationManager().checkPermission(this.getWikiSession(), new AllPermission(engine.getApplicationName()));
        return admin;
    }

    public void setPage(WikiPage page) {
        this.m_page = page;
        if (this.m_realPage == null) {
            this.m_realPage = page;
        }
    }

    public WikiPage setRealPage(WikiPage page) {
        WikiPage old = this.m_realPage;
        this.m_realPage = page;
        return old;
    }

    public void setRequestContext(String arg) {
        this.m_requestContext = arg;
    }

    public void setTemplate(String dir) {
        this.m_template = dir;
    }

    public void setVariable(String key, Object data) {
        this.m_variableMap.put(key, data);
    }

    protected void setHttpRequest(HttpServletRequest request) {
        ServletContext servletContext = request.getSession().getServletContext();
        this.m_engine = WikiEngine.getInstance(servletContext, null);
        this.m_request = request;
        this.m_session = SessionMonitor.getInstance(this.m_engine).find(request.getSession());
    }
}

