/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.ui.stripes;

import java.io.Writer;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.Message;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.controller.StripesFilter;
import net.sourceforge.stripes.validation.ValidationError;
import net.sourceforge.stripes.validation.ValidationErrors;
import org.json.JSONObject;

public class AjaxResolution
implements Resolution {
    private final JSONObject m_jsonobject;

    public AjaxResolution(ActionBeanContext context) {
        this(context, null);
    }

    public AjaxResolution(ActionBeanContext context, Object object) {
        this.m_jsonobject = new JSONObject((Object)new Result(context, object));
    }

    public void execute(HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.setContentType("application/json");
        this.m_jsonobject.write((Writer)response.getWriter());
        response.flushBuffer();
    }

    public static class Result {
        private final String m_errors;
        private final String m_messages;
        private final Object m_result;

        public Result(ActionBeanContext context, Object object) {
            this.m_messages = context.getMessages().size() > 0 ? this.generateMessages(context) : null;
            this.m_errors = context.getValidationErrors().size() > 0 ? this.generateErrors(context) : null;
            this.m_result = object;
        }

        public String getErrors() {
            return this.m_errors;
        }

        public String getMessages() {
            return this.m_messages;
        }

        public Object getResults() {
            return this.m_result;
        }

        private String generateErrors(ActionBeanContext context) {
            Locale locale = context.getLocale();
            ResourceBundle bundle = StripesFilter.getConfiguration().getLocalizationBundleFactory().getErrorMessageBundle(locale);
            String header = this.getMessage(bundle, "stripes.errors.header", "<div class=\"errorHeader\">Validation Errors</div><ul>");
            String footer = this.getMessage(bundle, "stripes.errors.footer", "</ul>");
            String beforeError = this.getMessage(bundle, "stripes.errors.beforeError", "<li>");
            String afterError = this.getMessage(bundle, "stripes.errors.afterError", "</li>");
            StringBuilder s = new StringBuilder();
            s.append(header);
            ValidationErrors errors = context.getValidationErrors();
            for (List errorList : errors.values()) {
                for (ValidationError error : errorList) {
                    s.append(beforeError);
                    s.append(error.getMessage(locale));
                    s.append(afterError);
                }
            }
            s.append(footer);
            return s.toString();
        }

        private String generateMessages(ActionBeanContext context) {
            Locale locale = context.getLocale();
            ResourceBundle bundle = StripesFilter.getConfiguration().getLocalizationBundleFactory().getErrorMessageBundle(locale);
            String header = this.getMessage(bundle, "stripes.messages.header", "<ul class=\"messages\">");
            String footer = this.getMessage(bundle, "stripes.messages.footer", "</ul>");
            String beforeMessage = this.getMessage(bundle, "stripes.messages.beforeMessage", "<li>");
            String afterMessage = this.getMessage(bundle, "stripes.messages.afterMessage", "</li>");
            StringBuilder s = new StringBuilder();
            s.append(header);
            for (Message message : context.getMessages()) {
                s.append(beforeMessage);
                s.append(message.getMessage(locale));
                s.append(afterMessage);
            }
            s.append(footer);
            return s.toString();
        }

        private String getMessage(ResourceBundle bundle, String key, String defaultValue) {
            String value = null;
            try {
                value = bundle.getString(key);
            }
            catch (MissingResourceException mre) {
                value = defaultValue;
            }
            return value;
        }
    }
}

