/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.ui.progress;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.apache.wiki.rpc.RPCCallable;
import org.apache.wiki.rpc.json.JSONRPCManager;
import org.apache.wiki.ui.progress.ProgressItem;

public class ProgressManager {
    private Map<String, ProgressItem> m_progressingTasks = new HashMap<String, ProgressItem>();
    public static final String JSON_PROGRESSTRACKER = "progressTracker";
    private static Logger log = LoggerFactory.getLogger(ProgressManager.class);

    public ProgressManager() {
        JSONRPCManager.registerGlobalObject(JSON_PROGRESSTRACKER, new JSONTracker());
    }

    public String getNewProgressIdentifier() {
        return UUID.randomUUID().toString();
    }

    public void startProgress(ProgressItem pi, String id) {
        log.debug("Adding " + id + " to progress queue", new Object[0]);
        this.m_progressingTasks.put(id, pi);
        pi.setState(1);
    }

    public void stopProgress(String id) {
        log.debug("Removed " + id + " from progress queue", new Object[0]);
        ProgressItem pi = this.m_progressingTasks.remove(id);
        if (pi != null) {
            pi.setState(2);
        }
    }

    public int getProgress(String id) throws IllegalArgumentException {
        ProgressItem pi = this.m_progressingTasks.get(id);
        if (pi != null) {
            return pi.getProgress();
        }
        throw new IllegalArgumentException("No such id was found");
    }

    public class JSONTracker
    implements RPCCallable {
        public int getProgress(String progressId) {
            return ProgressManager.this.getProgress(progressId);
        }
    }
}

