/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.ui.migrator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.wiki.ui.migrator.AbstractNode;
import org.apache.wiki.ui.migrator.Attribute;
import org.apache.wiki.ui.migrator.JspDocument;
import org.apache.wiki.ui.migrator.Node;
import org.apache.wiki.ui.migrator.NodeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tag
extends AbstractNode {
    private List<Attribute> m_attributes = new ArrayList<Attribute>();

    public Tag(JspDocument doc, NodeType type) {
        super(doc, type);
    }

    public void addAttribute(Attribute attribute) {
        this.m_attributes.add(attribute);
    }

    @Override
    public void addChild(Node node) {
        if (this.m_children.size() == 0) {
            this.addChild(node, 0);
        } else {
            super.addChild(node);
        }
    }

    @Override
    public void addChild(Node node, int index) {
        if (this.m_type == NodeType.EMPTY_ELEMENT_TAG) {
            if (this.m_parent == null) {
                throw new IllegalStateException("Node does not have a parent!");
            }
            this.m_type = NodeType.START_TAG;
            Tag endNode = new Tag(this.m_doc, NodeType.END_TAG);
            endNode.setName(this.m_name);
            endNode.setParent(this.m_parent);
            List<Node> siblings = this.m_parent.getChildren();
            int startTagPos = siblings.indexOf(this);
            if (startTagPos == siblings.size() - 1) {
                this.m_parent.addChild(endNode);
            } else {
                this.m_parent.addChild(endNode, startTagPos + 1);
            }
        }
        super.addChild(node, index);
    }

    public Attribute getAttribute(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null. ");
        }
        for (Attribute attribute : this.m_attributes) {
            if (!name.equals(attribute.getName())) continue;
            return attribute;
        }
        return null;
    }

    public List<Attribute> getAttributes() {
        ArrayList<Attribute> attributesCopy = new ArrayList<Attribute>();
        attributesCopy.addAll(this.m_attributes);
        return Collections.unmodifiableList(attributesCopy);
    }

    @Override
    public String getValue() {
        if (this.m_type != NodeType.START_TAG) {
            return null;
        }
        return super.getValue();
    }

    public boolean hasAttribute(String name) {
        return this.getAttribute(name) != null;
    }

    public void removeAttribute(Attribute attribute) {
        this.m_attributes.remove(attribute);
    }

    public String toString() {
        String tagEnd;
        StringBuilder sb;
        block9: {
            block8: {
                if (this.m_type == NodeType.ROOT) {
                    return "ROOT";
                }
                sb = new StringBuilder();
                String tagStart = this.m_type.getTagStart();
                tagEnd = this.m_type.getTagEnd();
                if (tagStart == null) {
                    tagStart = "?";
                }
                if (tagEnd == null) {
                    tagEnd = "?";
                }
                sb.append(tagStart);
                if (this.m_type == NodeType.JSP_DIRECTIVE) {
                    sb.append(' ');
                }
                if (!this.isHtmlNode() && this.m_type != NodeType.JSP_DIRECTIVE) break block8;
                sb.append(this.m_name);
                if (this.m_attributes.size() <= 0) break block9;
                int dynamicAttributeLevels = 0;
                NodeType lastType = null;
                for (Attribute attr : this.m_attributes) {
                    if (dynamicAttributeLevels == 0) {
                        sb.append(' ');
                    }
                    sb.append(attr.toString());
                    lastType = attr.getType();
                    if (lastType != NodeType.DYNAMIC_ATTRIBUTE || attr.getValue().length() <= 3) continue;
                    if (attr.getValue().charAt(1) != '/') {
                        ++dynamicAttributeLevels;
                        continue;
                    }
                    if (attr.getValue().charAt(attr.getValue().length() - 2) == '/') continue;
                    --dynamicAttributeLevels;
                }
                if (lastType != NodeType.DYNAMIC_ATTRIBUTE && this.m_type != NodeType.JSP_DIRECTIVE && this.m_type != NodeType.EMPTY_ELEMENT_TAG) break block9;
                sb.append(' ');
                break block9;
            }
            for (Node child : this.m_children) {
                sb.append(child.toString());
            }
        }
        sb.append(tagEnd);
        return sb.toString();
    }
}

