/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.ui.migrator;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.UrlBinding;
import org.apache.wiki.ui.migrator.AbstractJspTransformer;
import org.apache.wiki.ui.migrator.Attribute;
import org.apache.wiki.ui.migrator.JspDocument;
import org.apache.wiki.ui.migrator.JspMigrator;
import org.apache.wiki.ui.migrator.Node;
import org.apache.wiki.ui.migrator.NodeType;
import org.apache.wiki.ui.migrator.Tag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StripesJspTransformer
extends AbstractJspTransformer {
    private static final String STRIPES_TAGLIB_URI = "http://stripes.sourceforge.net/stripes.tld";
    private Map<Class<? extends ActionBean>, Set<String>> m_beanProperties = new HashMap<Class<? extends ActionBean>, Set<String>>();
    private Map<String, Class<? extends ActionBean>> m_beanBindings = new HashMap<String, Class<? extends ActionBean>>();
    private boolean m_migrateForms = false;

    @Override
    public void initialize(JspMigrator migrator, Set<Class<? extends ActionBean>> beanClasses, Map<String, Object> sharedState) {
        this.m_migrateForms = migrator.getFeature("stripes.migrator.migrateForms");
        this.initUrlBindingCache(beanClasses);
        this.initActionBeanPropertyCache(beanClasses);
        System.out.println("Initialized StripesJspTransformer.");
    }

    private void initUrlBindingCache(Set<Class<? extends ActionBean>> beanClasses) {
        for (Class<? extends ActionBean> beanClass : beanClasses) {
            UrlBinding binding = beanClass.getAnnotation(UrlBinding.class);
            if (binding == null || binding.value() == null) continue;
            this.m_beanBindings.put(binding.value(), beanClass);
        }
    }

    private void initActionBeanPropertyCache(Set<Class<? extends ActionBean>> beanClasses) {
        for (Class<? extends ActionBean> beanClass : beanClasses) {
            HashSet<String> properties = new HashSet<String>();
            try {
                PropertyDescriptor[] pds;
                PropertyDescriptor[] propertyDescriptorArray = pds = Introspector.getBeanInfo(beanClass).getPropertyDescriptors();
                int n = pds.length;
                int n2 = 0;
                while (n2 < n) {
                    PropertyDescriptor pd = propertyDescriptorArray[n2];
                    String propertyName = pd.getName();
                    boolean hasSetter = pd.getWriteMethod() != null;
                    boolean hasField = false;
                    try {
                        Field field = beanClass.getDeclaredField(propertyName);
                        hasField = field != null;
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        // empty catch block
                    }
                    if (hasSetter || hasField) {
                        properties.add(propertyName);
                    }
                    ++n2;
                }
                if (properties.size() <= 0) continue;
                this.m_beanProperties.put(beanClass, properties);
            }
            catch (IntrospectionException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void transform(Map<String, Object> sharedState, JspDocument doc) {
        boolean migrated = false;
        List<Node> nodes = doc.getNodes();
        for (Node node : nodes) {
            if (!node.isHtmlNode()) continue;
            Tag tag = (Tag)node;
            if (this.m_migrateForms && "form".equals(tag.getName())) {
                migrated = this.migrateFormTag(tag) || migrated;
                continue;
            }
            if (this.m_migrateForms && "input".equals(tag.getName())) {
                migrated = this.migrateInputTag(tag) || migrated;
                continue;
            }
            if (this.m_migrateForms && "textarea".equals(tag.getName())) {
                migrated = this.migrateTextArea(tag) || migrated;
                continue;
            }
            if (this.m_migrateForms && "label".equals(tag.getName())) {
                migrated = this.migrateLabel(tag) || migrated;
                continue;
            }
            if (!"fmt:setLocale".equals(tag.getName())) continue;
            this.removeSetLocale(tag);
        }
        if (migrated && StripesJspTransformer.addStripesTaglib(doc)) {
            this.message(doc.getRoot(), "Added Stripes taglib directive.");
        }
    }

    protected static boolean addStripesTaglib(JspDocument doc) {
        List<Tag> nodes = doc.getTaglibDirective("*", "stripes");
        if (nodes.size() == 0) {
            doc.addTaglibDirective(STRIPES_TAGLIB_URI, "stripes");
            return true;
        }
        for (Tag tag : nodes) {
            Attribute attr = tag.getAttribute("uri");
            if (attr == null) {
                tag.addAttribute(new Attribute(doc, "uri", STRIPES_TAGLIB_URI));
                continue;
            }
            if (STRIPES_TAGLIB_URI.equals(attr.getValue())) continue;
            attr.setValue(STRIPES_TAGLIB_URI);
        }
        return true;
    }

    private boolean migrateLabel(Tag tag) {
        tag.setName("stripes:label");
        this.migrateMessageTag(tag);
        this.message(tag, "Changed <label> to <stripes:label>.");
        return true;
    }

    private boolean migrateMessageTag(Tag tag) {
        boolean hasTwoTags;
        if (tag.getType() != NodeType.START_TAG) {
            return false;
        }
        List<Node> children = tag.getChildren();
        boolean hasOneTag = children.size() == 1 && children.get(0).getType() == NodeType.EMPTY_ELEMENT_TAG && "fmt:message".equals(children.get(0).getName());
        boolean bl = hasTwoTags = children.size() == 2 && children.get(0).getType() == NodeType.START_TAG && children.get(1).getType() == NodeType.END_TAG && "fmt.message".equals(children.get(0).getName()) && "fmt.message".equals(children.get(1).getName());
        if (hasOneTag || hasTwoTags) {
            if (tag.hasAttribute("name")) {
                this.message(children.get(0), "NOTE: did not migrate <fmt:message> tag because parent <" + tag.getName() + "> already has 'name' attribute. Refactor?");
            } else {
                Tag message = (Tag)children.get(0);
                if (message.hasAttribute("key")) {
                    Attribute key = message.getAttribute("key");
                    key.setName("name");
                    message.removeAttribute(key);
                    tag.addAttribute(key);
                    for (Node child : tag.getChildren()) {
                        tag.removeChild(child);
                    }
                }
                tag.setType(NodeType.EMPTY_ELEMENT_TAG);
                int i = tag.getParent().getChildren().indexOf(tag);
                Node endTag = tag.getParent().getChildren().get(i + 1);
                tag.getParent().removeChild(endTag);
                this.message(tag, "Moved <fmt:message> tag into parent <" + tag.getName() + ">.");
                return true;
            }
        }
        return false;
    }

    private boolean migrateFormTag(Tag tag) {
        int qmark;
        String actionUrl;
        this.message(tag, "Changed name to <stripes:form>.");
        tag.setName("stripes:form");
        Attribute attribute = tag.getAttribute("accept-charset");
        if (attribute != null) {
            this.message(attribute, "Changed name to \"acceptcharset\".");
            attribute.setName("acceptcharset");
        }
        if ((attribute = tag.getAttribute("action")) != null && (actionUrl = attribute.getValue()) != null && (qmark = actionUrl.indexOf(63)) != -1 && qmark < actionUrl.length() - 1) {
            String[] params;
            String trimmedPath = actionUrl.substring(0, qmark);
            this.message(attribute, "Trimmed value to \"" + trimmedPath + "\"");
            attribute.setValue(trimmedPath);
            String[] stringArray = params = actionUrl.substring(qmark + 1).split("&");
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                String param = stringArray[n2];
                if (param.length() > 1) {
                    JspDocument doc = tag.getJspDocument();
                    String name = param.substring(0, param.indexOf(61));
                    String value = param.substring(name.length() + 1);
                    Tag stripesParam = new Tag(doc, NodeType.EMPTY_ELEMENT_TAG);
                    stripesParam.setName("stripes:param");
                    Attribute nameAttribute = new Attribute(doc);
                    nameAttribute.setName("name");
                    nameAttribute.setValue(name);
                    stripesParam.addAttribute(nameAttribute);
                    Attribute valueAttribute = new Attribute(doc);
                    valueAttribute.setName("value");
                    valueAttribute.setValue(value);
                    stripesParam.addAttribute(valueAttribute);
                    tag.addChild(stripesParam);
                    this.message(tag, "Created <stripes:form> child element <stripes:param name=\"" + name + "\"" + " value=\"" + value + "\"/>.");
                }
                ++n2;
            }
        }
        return true;
    }

    private boolean migrateInputTag(Tag tag) {
        boolean migrated = false;
        Attribute attribute = tag.getAttribute("type");
        if (attribute != null) {
            if ("submit".equals(attribute.getValue())) {
                Attribute nameAttribute = tag.getAttribute("name");
                String nameValue = nameAttribute == null ? "(not set)" : nameAttribute.getName();
                this.message(nameAttribute, "NOTE: name=\"" + nameValue + "\"");
            }
            String type = attribute.getValue();
            this.message(attribute, "Changed <input type=\"" + type + "\"> to <stripes:" + type + ">.");
            tag.setName("stripes:" + type);
            tag.removeAttribute(attribute);
            migrated = true;
        }
        boolean bl = migrated = this.migrateValueAttribute(tag) || migrated;
        return this.migrateMessageTag(tag) || migrated;
    }

    private boolean migrateTextArea(Tag tag) {
        boolean migrated = false;
        Attribute name = tag.getAttribute("name");
        if (name != null) {
            tag.setName("stripes:textarea");
            this.message(tag, "Changed <textarea> to <stripes:textarea>. NOTE: Stripes will attempt to bind request parameter \"" + name.getValue() + "\" to this element.");
            this.migrateValueAttribute(tag);
            migrated = true;
        } else {
            this.message(tag, "NOTE: <textarea> did not contain a \"name\" attribute, so it was not migrated.");
        }
        return migrated;
    }

    private boolean migrateValueAttribute(Tag tag) {
        List<Node> attributeNodes;
        boolean migrated = false;
        Attribute attribute = tag.getAttribute("value");
        if (attribute != null && ((attributeNodes = attribute.getChildren()).size() > 1 || attributeNodes.size() == 1 && attributeNodes.get(0).getType() != NodeType.TEXT)) {
            tag.removeAttribute(attribute);
            for (Node valueNode : attribute.getChildren()) {
                tag.addChild(valueNode);
            }
            this.message(attribute, "Moved embedded tag(s) in <" + tag.getName() + "> \"value\" attribute to the tag body. These are now child element(s).");
            migrated = true;
        }
        return migrated;
    }

    private void removeSetLocale(Tag tag) {
        Node parent = tag.getParent();
        parent.removeChild(tag);
        this.message(tag, "Removed <fmt:setLocale> tag because Stripes LocalePicker does this instead.");
    }
}

