/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.ui.migrator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.wiki.ui.migrator.Attribute;
import org.apache.wiki.ui.migrator.JspDocument;
import org.apache.wiki.ui.migrator.Node;
import org.apache.wiki.ui.migrator.NodeType;
import org.apache.wiki.ui.migrator.Tag;
import org.apache.wiki.ui.migrator.Text;

public class JspParser {
    private static final Parser TEXT_PARSER = new TextParser();
    private static final Parser TAG_PARSER = new TagParser();
    private static final AttributeParser ATTRIBUTE_PARSER = new AttributeParser();
    private static final DynamicAttributeParser DYNAMIC_ATTRIBUTE_PARSER = new DynamicAttributeParser();

    public JspDocument parse(String source) {
        JspDocument doc = new JspDocument();
        ParseContext ctx = ParseContext.initialContext(doc, source);
        int pos = ctx.position();
        while (pos < source.length()) {
            ctx = ParseContext.currentContext();
            char currentChar = source.charAt(pos);
            boolean isWhitespace = Character.isWhitespace(currentChar);
            char ch = isWhitespace ? (char)' ' : (char)currentChar;
            Parser parser = ctx.getParser();
            parser.handle(ch);
            ctx.incrementPosition();
            pos = ctx.position();
        }
        Node node = ctx.getNode();
        node.setEnd(ctx.position());
        if (node.getType() == NodeType.TEXT) {
            ctx.getParser().endStage();
        }
        return doc;
    }

    public static class AttributeParser
    implements Parser {
        public void beginStage() {
            ParseContext ctx = ParseContext.currentContext();
            Attribute attribute = new Attribute(ctx.getDocument());
            ctx.setNode(attribute);
        }

        public void endStage() {
            ParseContext ctx = ParseContext.currentContext();
            Node attribute = ctx.getNode();
            attribute.setEnd(ctx.position());
        }

        public void handle(char ch) {
            ParseContext ctx = ParseContext.currentContext();
            int pos = ctx.position();
            switch (ctx.getStage()) {
                case NAME: {
                    if (ch != '=') break;
                    Attribute attribute = (Attribute)ctx.getNode();
                    attribute.setName(ctx.getSource().substring(attribute.getStart(), pos));
                    ctx.incrementPosition();
                    char delimiter = ctx.getSource().charAt(ctx.position());
                    attribute.setAttributeDelimiter(delimiter);
                    ctx = ParseContext.push();
                    ctx.setStartPosition(ctx.getNode(), ctx.position() + 1);
                    break;
                }
                case ATTRIBUTE_END: {
                    Attribute attribute = (Attribute)ctx.getNode();
                    Tag parent = (Tag)attribute.getParent();
                    parent.addAttribute(attribute);
                    ctx = ParseContext.pop();
                    Parser parser = ctx.getParser();
                    parser.handle(ch);
                }
            }
        }
    }

    private static final class Counter {
        private int m_pos = 0;
        private final List<Integer> lineBreaks = new ArrayList<Integer>();

        Counter() {
        }

        public void increment() {
            ++this.m_pos;
        }

        public int position() {
            return this.m_pos;
        }
    }

    public static class DynamicAttributeParser
    implements Parser {
        public void beginStage() {
        }

        public void endStage() {
        }

        public void handle(char ch) {
            ParseContext ctx = ParseContext.currentContext();
            int leftAngleBrackets = 1;
            boolean increment = false;
            do {
                if (increment) {
                    ctx.incrementPosition();
                }
                ch = ctx.getSource().charAt(ctx.position());
                switch (ch) {
                    case '<': {
                        ++leftAngleBrackets;
                        break;
                    }
                    case '>': {
                        --leftAngleBrackets;
                        break;
                    }
                    default: {
                        increment = true;
                    }
                }
            } while (leftAngleBrackets != 0);
            Attribute attribute = (Attribute)ctx.getNode();
            ctx.setEndPosition(attribute);
            attribute.setType(NodeType.DYNAMIC_ATTRIBUTE);
            attribute.setValue(ctx.getSource().substring(ctx.getMarkerForStage(Stage.CODE_OR_COMMENT), attribute.getEnd()));
            Tag parent = (Tag)ctx.getParentContext().getNode();
            parent.addAttribute(attribute);
            ParseContext.pop();
        }
    }

    private static class ParseContext {
        private static final Stack<ParseContext> CONTEXT_STACK = new Stack();
        private static ParseContext CURRENT_CONTEXT;
        private Parser m_parser = null;
        private Node m_node = null;
        private final Counter m_counter;
        private final String m_source;
        private Stage m_stage = Stage.TEXT;
        private JspDocument m_doc;
        private Map<Stage, Integer> m_markers = new HashMap<Stage, Integer>();

        public static ParseContext currentContext() {
            return CURRENT_CONTEXT;
        }

        public static ParseContext initialContext(JspDocument doc, String source) {
            ParseContext context;
            CONTEXT_STACK.clear();
            CURRENT_CONTEXT = context = new ParseContext(doc, source, new Counter());
            Text text = new Text(doc);
            context.setNode(text);
            context.setStartPosition(text, 0);
            context.m_stage = Stage.TEXT;
            context.m_parser = TEXT_PARSER;
            return context;
        }

        private ParseContext(JspDocument doc, String source, Counter counter) {
            this.m_doc = doc;
            this.m_source = source;
            this.m_counter = counter;
        }

        public String lookahead(int length) {
            int endPos;
            int startPos = this.position();
            endPos = startPos + length > this.m_source.length() ? (endPos = this.m_source.length()) : startPos + length;
            return this.m_source.substring(startPos, endPos);
        }

        public String lookbehind(int length) {
            int endPos = this.position() + 1;
            int startPos = endPos - length < 0 ? 0 : endPos - length;
            return this.m_source.substring(startPos, endPos);
        }

        public Counter getCounter() {
            return this.m_counter;
        }

        public JspDocument getDocument() {
            return this.m_doc;
        }

        public int getMarkerForStage(Stage stage) {
            Integer mark = this.m_markers.get((Object)stage);
            return mark == null ? -1 : mark;
        }

        public Node getNode() {
            return this.m_node;
        }

        public void setParser(Parser parser) {
            this.m_parser = parser;
        }

        public ParseContext getParentContext() {
            return CONTEXT_STACK.size() == 0 ? null : CONTEXT_STACK.peek();
        }

        public Parser getParser() {
            return this.m_parser;
        }

        public String getSource() {
            return this.m_source;
        }

        public Stage getStage() {
            return this.m_stage;
        }

        public boolean hasParentContext() {
            return CONTEXT_STACK.size() > 0;
        }

        public void incrementPosition() {
            char nextChar;
            int pos = this.position();
            char currentChar = this.m_source.charAt(pos);
            char c = nextChar = pos + 1 < this.m_source.length() ? this.m_source.charAt(pos + 1) : currentChar;
            if (currentChar == '\r' && nextChar == '\n') {
                this.m_counter.lineBreaks.add(pos);
                this.m_counter.increment();
            } else if (currentChar == '\r' || currentChar == '\n') {
                this.m_counter.lineBreaks.add(pos);
            }
            this.m_counter.increment();
        }

        public static ParseContext pop() {
            ParseContext ctx = ParseContext.currentContext();
            ctx.getParser().endStage();
            CURRENT_CONTEXT = ctx = CONTEXT_STACK.pop();
            return ctx;
        }

        public int position() {
            return this.m_counter.position();
        }

        public static ParseContext push() {
            ParseContext ctx;
            ParseContext oldCtx = ParseContext.currentContext();
            CONTEXT_STACK.push(oldCtx);
            CURRENT_CONTEXT = ctx = new ParseContext(oldCtx.m_doc, oldCtx.m_source, oldCtx.m_counter);
            Text text = new Text(ctx.m_doc);
            ctx.setNode(text);
            ctx.m_stage = Stage.TEXT;
            ctx.m_parser = TEXT_PARSER;
            return ctx;
        }

        public void setNode(Node node) {
            this.m_node = node;
            if (node == null) {
                return;
            }
            if (node.getStart() == -1) {
                this.setStartPosition(node, this.position());
            }
            if (node.getParent() == null) {
                if (this.getParentContext() == null) {
                    node.setParent(this.m_doc.getRoot());
                } else {
                    node.setParent(this.getParentContext().getNode());
                }
            }
        }

        public void setStage(Stage stage, int increment) {
            this.m_stage = stage;
            this.m_markers.put(this.getStage(), this.position() + increment);
        }

        public void setParser(Parser parser, Stage stage, int increment) {
            if (parser != null && this.m_parser != null) {
                this.m_parser.endStage();
            }
            this.m_stage = stage;
            this.m_markers.put(stage, this.position() + increment);
            if (parser != null) {
                this.m_parser = parser;
                this.m_parser.beginStage();
            }
        }

        private void setStartPosition(Node node, int pos) {
            node.setStart(pos);
            int lastLineBreakPos = this.m_counter.lineBreaks.size() == 0 ? -1 : (Integer)this.m_counter.lineBreaks.get(this.m_counter.lineBreaks.size() - 1);
            node.setLine(this.m_counter.lineBreaks.size() + 1);
            node.setColumn(pos - lastLineBreakPos);
        }

        private void setEndPosition(Node node) {
            ParseContext ctx = ParseContext.currentContext();
            int pos = ctx.position() + 1;
            if (pos > ctx.getSource().length()) {
                pos = ctx.getSource().length();
            }
            node.setEnd(pos);
        }
    }

    public static interface Parser {
        public void beginStage();

        public void endStage();

        public void handle(char var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Stage {
        TAG_START,
        TEXT,
        NAME,
        WHITESPACE,
        CODE_OR_COMMENT,
        ATTRIBUTE_END;

    }

    public static class TagParser
    implements Parser {
        private void initNode(Node node, Stage stage) {
            ParseContext ctx = ParseContext.currentContext();
            ctx.setNode(node);
            int pos = ctx.position();
            int increment = node.getType().getTagStart().length();
            String source = ctx.getSource();
            while (pos + increment < source.length() && Character.isWhitespace(source.charAt(pos + increment))) {
                ++increment;
            }
            --increment;
            int i = 0;
            while (i < increment) {
                ctx.incrementPosition();
                ++i;
            }
            ctx.setStage(stage, 1);
        }

        public void beginStage() {
            ParseContext ctx = ParseContext.currentContext();
            String lookahead = ctx.lookahead(10);
            JspDocument doc = ctx.getDocument();
            if (lookahead.startsWith(NodeType.JSP_COMMENT.getTagStart())) {
                this.initNode(new Text(doc, NodeType.JSP_COMMENT), Stage.CODE_OR_COMMENT);
            } else if (lookahead.startsWith(NodeType.JSP_DECLARATION.getTagStart())) {
                this.initNode(new Text(doc, NodeType.JSP_DECLARATION), Stage.CODE_OR_COMMENT);
            } else if (lookahead.startsWith(NodeType.JSP_EXPRESSION.getTagStart())) {
                this.initNode(new Text(doc, NodeType.JSP_EXPRESSION), Stage.CODE_OR_COMMENT);
            } else if (lookahead.startsWith(NodeType.JSP_DIRECTIVE.getTagStart())) {
                this.initNode(new Tag(doc, NodeType.JSP_DIRECTIVE), Stage.NAME);
            } else if (lookahead.startsWith(NodeType.COMMENT.getTagStart())) {
                this.initNode(new Text(doc, NodeType.COMMENT), Stage.CODE_OR_COMMENT);
            } else if (lookahead.startsWith(NodeType.SCRIPTLET.getTagStart())) {
                if (lookahead.length() >= 3 && Character.isWhitespace(lookahead.charAt(2))) {
                    this.initNode(new Text(doc, NodeType.SCRIPTLET), Stage.CODE_OR_COMMENT);
                }
            } else if (lookahead.startsWith(NodeType.DECLARATION.getTagStart())) {
                this.initNode(new Tag(doc, NodeType.DECLARATION), Stage.NAME);
            } else if (lookahead.startsWith(NodeType.DOCTYPE.getTagStart())) {
                this.initNode(new Text(doc, NodeType.DOCTYPE), Stage.CODE_OR_COMMENT);
            } else if (lookahead.startsWith(NodeType.CDATA.getTagStart())) {
                this.initNode(new Text(doc, NodeType.CDATA), Stage.CODE_OR_COMMENT);
            } else if (lookahead.startsWith(NodeType.END_TAG.getTagStart())) {
                this.initNode(new Tag(doc, NodeType.END_TAG), Stage.NAME);
            } else {
                this.initNode(new Tag(doc, NodeType.UNRESOLVED_TAG), Stage.NAME);
            }
        }

        public void endStage() {
            ParseContext ctx = ParseContext.currentContext();
            Node node = ctx.getNode();
            if (node != null) {
                ctx.setEndPosition(node);
                if (node.getEnd() > node.getStart()) {
                    node.getParent().addChild(node);
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void handle(char ch) {
            ParseContext ctx = ParseContext.currentContext();
            Node node = ctx.getNode();
            switch (ctx.getStage()) {
                case NAME: {
                    switch (ch) {
                        case ' ': {
                            int nameStart = ctx.getMarkerForStage(Stage.NAME);
                            int nameEnd = ctx.position();
                            node.setName(ctx.getSource().substring(nameStart, nameEnd));
                            ctx.setStage(Stage.WHITESPACE, 0);
                            return;
                        }
                        case '>': {
                            this.handleTagEnd();
                        }
                    }
                    return;
                }
                case WHITESPACE: {
                    switch (ch) {
                        case ' ': 
                        case '%': 
                        case '/': 
                        case '?': {
                            return;
                        }
                        case '<': {
                            ctx = ParseContext.push();
                            ctx.setParser(DYNAMIC_ATTRIBUTE_PARSER, Stage.CODE_OR_COMMENT, 0);
                            ctx.setNode(new Attribute(ctx.getDocument()));
                            return;
                        }
                        case '>': {
                            this.handleTagEnd();
                            return;
                        }
                    }
                    ctx = ParseContext.push();
                    ctx.setParser(ATTRIBUTE_PARSER, Stage.NAME, 0);
                    return;
                }
                case CODE_OR_COMMENT: {
                    switch (ch) {
                        case '>': {
                            String tagEnd = node.getType().getTagEnd();
                            String lookbehind = ctx.lookbehind(tagEnd.length());
                            if (!lookbehind.equals(tagEnd)) return;
                            node.setEnd(ctx.position() + 1);
                            NodeType type = node.getType();
                            node.setValue(ctx.getSource().substring(node.getStart() + type.getTagStart().length(), node.getEnd() - type.getTagEnd().length()));
                            ctx.setParser(TEXT_PARSER, Stage.TEXT, 1);
                        }
                    }
                }
            }
        }

        private void handleTagEnd() {
            ParseContext ctx = ParseContext.currentContext();
            Node node = ctx.getNode();
            if ("LINK".equals(node.getName())) {
                node.setType(NodeType.LINK);
            } else if ("META".equals(node.getName())) {
                node.setType(NodeType.META);
            }
            if (node.getType() == NodeType.UNRESOLVED_TAG) {
                String lookbehind = ctx.lookbehind(2);
                if (NodeType.EMPTY_ELEMENT_TAG.getTagEnd().equals(lookbehind)) {
                    node.setType(NodeType.EMPTY_ELEMENT_TAG);
                } else {
                    node.setType(NodeType.START_TAG);
                }
            }
            if (node.getName() == null) {
                int nameStart = ctx.getMarkerForStage(Stage.NAME);
                int nameEnd = ctx.position() + 1 - node.getType().getTagEnd().length();
                node.setName(ctx.getSource().substring(nameStart, nameEnd));
            }
            switch (node.getType()) {
                case START_TAG: {
                    this.endStage();
                    ctx = ParseContext.push();
                    break;
                }
                case END_TAG: {
                    Node startTag = node.getParent();
                    node.setParent(startTag.getParent());
                    if (!node.getName().equals(startTag.getName())) {
                        if (startTag.equals(ctx.getDocument().getRoot())) {
                            throw new IllegalStateException("Encountered end tag </" + node.getName() + "> (" + node.getLine() + "," + node.getColumn() + " char " + node.getStart() + ") that did have a matching start tag.");
                        }
                        throw new IllegalStateException("Encountered end tag </" + node.getName() + "> (" + node.getLine() + "," + node.getColumn() + " char " + node.getStart() + ") that did not match start tag <" + startTag.getName() + "> (" + startTag.getLine() + "," + startTag.getColumn() + " char " + startTag.getEnd() + ")");
                    }
                    ctx = ParseContext.pop();
                    ctx.setNode(null);
                }
            }
            ctx.setParser(TEXT_PARSER, Stage.TEXT, 1);
        }
    }

    public static class TextParser
    implements Parser {
        public void beginStage() {
            ParseContext ctx = ParseContext.currentContext();
            Text text = new Text(ctx.getDocument());
            ctx.setNode(text);
            ctx.setStartPosition(ctx.getNode(), ctx.position() + 1);
        }

        public void endStage() {
            ParseContext ctx = ParseContext.currentContext();
            if (ctx.position() > 0) {
                Node node = ctx.getNode();
                node.setEnd(ctx.position());
                node.setValue(ctx.getSource().substring(node.getStart(), node.getEnd()));
                if (node.getEnd() > node.getStart()) {
                    node.getParent().addChild(node);
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        public void handle(char ch) {
            ParseContext ctx = ParseContext.currentContext();
            switch (ctx.getStage()) {
                case TEXT: {
                    switch (ch) {
                        case '\"': 
                        case '\'': {
                            Attribute attribute;
                            Node node = ctx.getNode();
                            Node parent = node.getParent();
                            if (!(parent instanceof Attribute) || ch != (attribute = (Attribute)parent).getAttributeDelimiter()) return;
                            ctx = ParseContext.pop();
                            ctx.setStage(Stage.ATTRIBUTE_END, 0);
                            break;
                        }
                        case '<': {
                            char nextChar;
                            String lookahead = ctx.lookahead(2);
                            if (lookahead.length() != 2 || "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ!/%_:?".indexOf(nextChar = lookahead.charAt(1)) == -1) return;
                            ctx.setParser(TAG_PARSER, Stage.TAG_START, 0);
                        }
                    }
                    return;
                }
            }
        }
    }
}

