/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.ui.migrator;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.util.ResolverUtil;
import org.apache.wiki.ui.migrator.JSPWikiJspTransformer;
import org.apache.wiki.ui.migrator.JspDocument;
import org.apache.wiki.ui.migrator.JspParser;
import org.apache.wiki.ui.migrator.JspTransformer;
import org.apache.wiki.ui.migrator.StripesJspTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JspMigrator {
    protected static final String ALL_JSPS = "allJSPs";
    public static final String MIGRATE_FORMS = "stripes.migrator.migrateForms";
    private Map<String, Boolean> m_features = new HashMap<String, Boolean>();
    private List<JspTransformer> m_transformers = new ArrayList<JspTransformer>();
    private Map<String, Object> m_sharedState = new HashMap<String, Object>();

    public static List<File> getFiles(File dir, String extension) throws IOException {
        if (dir == null || extension == null) {
            throw new IllegalArgumentException("Dir and extension must not be null.");
        }
        if (!dir.exists()) {
            throw new IllegalArgumentException("Dir " + dir.getPath() + " does not exist!");
        }
        ArrayList<File> allFiles = new ArrayList<File>();
        File[] fileArray = dir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                allFiles.addAll(JspMigrator.getFiles(file, extension));
            } else if ("*".equals(extension) || file.getName().endsWith(extension)) {
                allFiles.add(file);
            }
            ++n2;
        }
        return allFiles;
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            throw new IllegalArgumentException("Must supply source and destination directories.");
        }
        File src = new File(args[0]);
        File dest = new File(args[1]);
        if (!src.exists()) {
            throw new IllegalArgumentException("Source directory " + src.getAbsolutePath() + " does not exist.");
        }
        if (!src.isDirectory()) {
            throw new IllegalArgumentException("Source " + src.getAbsolutePath() + " is not a directory.");
        }
        if (!dest.exists()) {
            throw new IllegalArgumentException("Destination directory " + dest.getAbsolutePath() + " does not exist!");
        }
        if (!src.isDirectory()) {
            throw new IllegalArgumentException("Destination " + dest.getAbsolutePath() + " is not a directory.");
        }
        if (src.equals(dest)) {
            throw new IllegalArgumentException("Source and destination cannot be the same.");
        }
        JspMigrator migrator = new JspMigrator();
        migrator.addTransformer(new StripesJspTransformer());
        migrator.addTransformer(new JSPWikiJspTransformer());
        migrator.initialize(new HashMap<String, Object>());
        try {
            migrator.migrate(src, dest);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected static Set<Class<? extends ActionBean>> findBeanClasses() {
        String beanPackagesProp = System.getProperty("ActionResolver.Packages", "org.apache.wiki.action").trim();
        String[] beanPackages = beanPackagesProp.split(",");
        ResolverUtil resolver = new ResolverUtil();
        resolver.findImplementations(ActionBean.class, beanPackages);
        Set beanClasses = resolver.getClasses();
        return beanClasses;
    }

    protected static String readSource(File src) throws IOException {
        FileReader reader = new FileReader(src);
        StringBuilder s = new StringBuilder();
        int ch = 0;
        while ((ch = reader.read()) != -1) {
            s.append((char)ch);
        }
        reader.close();
        return s.toString();
    }

    public void addTransformer(JspTransformer transformer) {
        this.m_transformers.add(transformer);
    }

    public boolean getFeature(String feature) {
        if (feature == null) {
            throw new IllegalArgumentException("Feature cannot be null.");
        }
        Boolean featureValue = this.m_features.get(feature);
        return featureValue == null ? false : featureValue;
    }

    public void initialize(Map<String, Object> sharedState) {
        boolean migrateForms = Boolean.getBoolean(MIGRATE_FORMS);
        this.setFeature(MIGRATE_FORMS, migrateForms);
        this.m_sharedState = sharedState;
        for (JspTransformer transformer : this.m_transformers) {
            transformer.initialize(this, JspMigrator.findBeanClasses(), this.m_sharedState);
        }
    }

    public void migrate(File sourceDir, File destDir) throws IOException {
        String sourcePath = sourceDir.getPath();
        List<File> allFiles = Collections.unmodifiableList(JspMigrator.getFiles(sourceDir, ".jsp"));
        this.m_sharedState.put(ALL_JSPS, allFiles);
        for (File src : allFiles) {
            String destPath = src.getPath().substring(sourcePath.length());
            File dest = new File(destDir, destPath);
            dest.getParentFile().mkdirs();
            this.migrateFile(src, dest);
        }
    }

    public void setFeature(String feature, boolean value) {
        if (feature == null) {
            throw new IllegalArgumentException("Feature cannot be null.");
        }
        this.m_features.put(feature, value);
    }

    private void writeDestination(File dest, String contents) throws IOException {
        FileWriter writer = new FileWriter(dest);
        writer.append(contents);
        writer.close();
    }

    protected void migrateFile(File src, File dest) throws IOException {
        System.out.println("Migrating " + src.getPath() + " ----> " + dest.getPath());
        String s = JspMigrator.readSource(src);
        JspParser parser = new JspParser();
        JspDocument doc = parser.parse(s.toString());
        for (JspTransformer transformer : this.m_transformers) {
            transformer.transform(this.m_sharedState, doc);
        }
        this.writeDestination(dest, doc.toString());
        System.out.println("    done [" + s.length() + " chars].");
    }
}

