/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.ui.migrator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.wiki.ui.migrator.AbstractNode;
import org.apache.wiki.ui.migrator.Attribute;
import org.apache.wiki.ui.migrator.Node;
import org.apache.wiki.ui.migrator.NodeType;
import org.apache.wiki.ui.migrator.Tag;
import org.apache.wiki.ui.migrator.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JspDocument {
    private final AbstractNode root = new Tag(this, NodeType.ROOT);

    public List<Node> getNodes() {
        ArrayList<Node> allNodes = new ArrayList<Node>();
        this.visitChildren(allNodes, this.root.getChildren());
        return Collections.unmodifiableList(allNodes);
    }

    public List<Node> getScriptNodes() {
        ArrayList<Node> scriptNodes = new ArrayList<Node>();
        List<Node> nodes = this.getNodes();
        block4: for (Node node : nodes) {
            switch (node.getType()) {
                case CDATA: 
                case JSP_DECLARATION: 
                case JSP_EXPRESSION: 
                case SCRIPTLET: {
                    scriptNodes.add(node);
                    break;
                }
                case START_TAG: 
                case EMPTY_ELEMENT_TAG: {
                    Tag tag = (Tag)node;
                    for (Attribute attribute : tag.getAttributes()) {
                        if (attribute.getType() != NodeType.ATTRIBUTE) continue;
                        for (Node attributeNode : attribute.getChildren()) {
                            if (attributeNode.getType() != NodeType.JSP_EXPRESSION) continue;
                            scriptNodes.add(attributeNode);
                        }
                    }
                    continue block4;
                }
            }
        }
        return scriptNodes;
    }

    public List<Node> getNodes(NodeType type) {
        ArrayList<Node> typeNodes = new ArrayList<Node>();
        for (Node node : this.getNodes()) {
            if (node.getType() != type) continue;
            typeNodes.add(node);
        }
        return Collections.unmodifiableList(typeNodes);
    }

    public boolean addPageImportDirective(Class<? extends Object> clazz) {
        List<Tag> imports = this.getPageImport(clazz);
        if (imports.size() > 0) {
            return false;
        }
        String type = clazz.getName();
        Tag directive = new Tag(this, NodeType.JSP_DIRECTIVE);
        directive.setName("page");
        directive.addAttribute(new Attribute(this, "import", type));
        Text linebreak = new Text(this);
        linebreak.setValue(System.getProperty("line.separator"));
        linebreak.setParent(this.root);
        List<Node> directives = this.getNodes(NodeType.JSP_DIRECTIVE);
        if (directives.size() == 0) {
            this.root.addChild(linebreak, 0);
            this.root.addChild(directive, 0);
        } else {
            Node lastDirective = directives.get(directives.size() - 1);
            lastDirective.addSibling(directive);
            lastDirective.addSibling(linebreak);
        }
        return true;
    }

    public void addTaglibDirective(String uri, String prefix) {
        Tag directive = new Tag(this, NodeType.JSP_DIRECTIVE);
        directive.setName("taglib");
        directive.addAttribute(new Attribute(this, "uri", uri));
        directive.addAttribute(new Attribute(this, "prefix", prefix));
        Text linebreak = new Text(this);
        linebreak.setValue(System.getProperty("line.separator"));
        linebreak.setParent(this.root);
        List<Node> directives = this.getNodes(NodeType.JSP_DIRECTIVE);
        if (directives.size() == 0) {
            this.root.addChild(linebreak, 0);
            this.root.addChild(directive, 0);
        } else {
            Node lastDirective = directives.get(directives.size() - 1);
            lastDirective.addSibling(directive);
            lastDirective.addSibling(linebreak);
        }
    }

    public List<Tag> getPageImport(Class<? extends Object> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Class cannot be null.");
        }
        String type = clazz.getName();
        int periodPosition = type.lastIndexOf(46);
        String wildcardType = periodPosition == -1 ? "*" : String.valueOf(type.substring(0, periodPosition)) + ".*";
        List<Node> directives = this.getNodes(NodeType.JSP_DIRECTIVE);
        ArrayList<Tag> matchingDirectives = new ArrayList<Tag>();
        for (Node node : directives) {
            Tag directive = (Tag)node;
            Attribute imported = directive.getAttribute("import");
            if (!"page".equals(directive.getName()) || imported == null || !type.equals(imported.getValue()) && !wildcardType.equals(imported.getValue())) continue;
            matchingDirectives.add(directive);
        }
        return matchingDirectives;
    }

    public List<Tag> getTaglibDirective(String uri, String prefix) {
        if (uri == null || prefix == null) {
            throw new IllegalArgumentException("URI or prefix cannot be null.");
        }
        List<Node> directives = this.getNodes(NodeType.JSP_DIRECTIVE);
        ArrayList<Tag> matchingDirectives = new ArrayList<Tag>();
        for (Node node : directives) {
            boolean prefixMatch;
            Tag directive = (Tag)node;
            if (!"taglib".equals(directive.getName())) continue;
            String nodeUri = directive.getAttribute("uri").getValue();
            String nodePrefix = directive.getAttribute("prefix").getValue();
            boolean uriMatch = "*".equals(uri) || nodeUri.equals(uri);
            boolean bl = prefixMatch = "*".equals(prefix) || nodePrefix.equals(prefix);
            if (!uriMatch || !prefixMatch) continue;
            matchingDirectives.add(directive);
        }
        return matchingDirectives;
    }

    public List<Node> getChildren(Tag start) {
        ArrayList<Node> allChildren = new ArrayList<Node>();
        this.visitChildren(allChildren, start.getChildren());
        return allChildren;
    }

    public AbstractNode getRoot() {
        return this.root;
    }

    private void visitChildren(List<Node> collection, List<Node> children) {
        for (Node child : children) {
            collection.add(child);
            if (child.getChildren().size() < 0) continue;
            this.visitChildren(collection, child.getChildren());
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        List<Node> allNodes = this.getNodes();
        for (Node node : allNodes) {
            builder.append(node.toString());
        }
        return builder.toString();
    }
}

