/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.ui.migrator;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.stripes.action.ActionBean;
import org.apache.wiki.WikiContext;
import org.apache.wiki.action.WikiContextFactory;
import org.apache.wiki.search.SearchResult;
import org.apache.wiki.ui.migrator.AbstractJspTransformer;
import org.apache.wiki.ui.migrator.AbstractNode;
import org.apache.wiki.ui.migrator.Attribute;
import org.apache.wiki.ui.migrator.JspDocument;
import org.apache.wiki.ui.migrator.JspMigrator;
import org.apache.wiki.ui.migrator.Node;
import org.apache.wiki.ui.migrator.NodeType;
import org.apache.wiki.ui.migrator.StripesJspTransformer;
import org.apache.wiki.ui.migrator.Tag;
import org.apache.wiki.ui.migrator.Text;
import org.apache.wiki.ui.stripes.HandlerInfo;
import org.apache.wiki.util.FileUtil;
import org.apache.wiki.util.TextUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSPWikiJspTransformer
extends AbstractJspTransformer {
    private static final Pattern CONTEXT_PATTERN = Pattern.compile("\\.createContext\\(.*?WikiContext.([A-Z]*?)\\s*\\);");
    private static final Pattern HASACCESS_PATTERN = Pattern.compile("if\\s*\\(\\s*\\!(wikiContext|context|ctx)\\.hasAccess\\(.*?\\)\\s*\\)\\s*return;");
    private static final Pattern PAGE_GETNAME_PATTERN = Pattern.compile("(wikiContext|context|ctx)\\.getName\\(\\)");
    private static final Pattern FINDCONTEXT_PATTERN = Pattern.compile("WikiContext\\.findContext\\((.*?)\\)");
    private Map<String, HandlerInfo> m_contextMap = new HashMap<String, HandlerInfo>();

    @Override
    public void initialize(JspMigrator migrator, Set<Class<? extends ActionBean>> beanClasses, Map<String, Object> sharedState) {
        this.m_contextMap = this.cacheRequestContexts(beanClasses);
        System.out.println("Initialized JSPWikiJspTransformer.");
    }

    @Override
    public void transform(Map<String, Object> sharedState, JspDocument doc) {
        List<Node> nodes = doc.getNodes();
        for (Node node : nodes) {
            if (node.isHtmlNode()) {
                Tag tag = (Tag)node;
                if ("form".equals(tag.getName()) || "stripes:form".equals(tag.getName())) {
                    this.processFormTag(tag);
                } else if ("fmt:setBundle".equals(tag.getName())) {
                    this.removeSetBundle(tag);
                }
                boolean isTypeHidden = false;
                if (tag.getType() != NodeType.END_TAG) {
                    isTypeHidden = "stripes:hidden".equals(tag.getName());
                    if ("input".equals(tag.getName())) {
                        Attribute attribute = tag.getAttribute("type");
                        isTypeHidden = "hidden".equals(attribute.getValue());
                    }
                    if (isTypeHidden) {
                        String paramValue;
                        String paramName = tag.hasAttribute("name") ? tag.getAttribute("name").getValue() : null;
                        String string = paramValue = tag.hasAttribute("value") ? tag.getAttribute("value").getValue() : null;
                        if (paramName != null && paramValue != null) {
                            this.message(tag, "NOTE: hidden form input sets parameter " + paramName + "=\"" + paramValue + "\". This should probably correspond to a Stripes ActionBean getter/settter. Refactor?");
                        }
                    }
                }
                if ("wiki:Messages".equals(tag.getName())) {
                    this.message(tag, "Consider using <stripes:errors> tags instead of <wiki:Messages> for displaying validation errors.");
                }
            } else if (node.getType() == NodeType.JSP_DECLARATION || node.getType() == NodeType.SCRIPTLET || node.getType() == NodeType.JSP_EXPRESSION || node.getType() == NodeType.CDATA) {
                String ctx;
                String context;
                HandlerInfo handler;
                String scriptlet = node.getValue();
                Matcher m = CONTEXT_PATTERN.matcher(scriptlet);
                if (m.find() && (handler = this.m_contextMap.get(context = m.group(1).trim())) != null) {
                    this.addUseActionBeanTag(doc, handler.getActionBeanClass(), handler.getEventName());
                    if (StripesJspTransformer.addStripesTaglib(doc)) {
                        this.message(doc.getRoot(), "Added Stripes taglib directive.");
                    }
                }
                if ((m = HASACCESS_PATTERN.matcher(scriptlet)).find()) {
                    String hasAccess = m.group(0);
                    scriptlet = scriptlet.replace(hasAccess, "");
                    node.setValue(scriptlet);
                    this.message(node, "Removed WikiContext.hasAccess() statement.");
                }
                if ((m = PAGE_GETNAME_PATTERN.matcher(scriptlet)).find()) {
                    String getName = m.group(0);
                    ctx = m.group(1).trim();
                    scriptlet = scriptlet.replace(getName, String.valueOf(ctx) + ".getPage().getName()");
                    node.setValue(scriptlet);
                    this.message(node, "Changed WikiContext.getName() statement to WikiContext.getPage().getName().");
                }
                if ((m = FINDCONTEXT_PATTERN.matcher(scriptlet)).find()) {
                    String findContext = m.group(0);
                    ctx = m.group(1).trim();
                    scriptlet = scriptlet.replace(findContext, "WikiContextFactory.findContext( " + ctx + " )");
                    node.setValue(scriptlet);
                    this.message(node, "Changed WikiContext.findContext() statement to WikiContextFactory.findContext().");
                    doc.addPageImportDirective(WikiContextFactory.class);
                }
            }
            this.verifyImports(doc, SearchResult.class, FileUtil.class, TextUtil.class);
        }
    }

    private void verifyImports(JspDocument doc, Class<? extends Object> ... clazzes) {
        HashMap<String, Class<? extends Object>> classNames = new HashMap<String, Class<? extends Object>>();
        StringBuilder s = new StringBuilder();
        s.append('(');
        Class<? extends Object>[] classArray = clazzes;
        int n = clazzes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<? extends Object> clazz = classArray[n2];
            classNames.put(clazz.getSimpleName(), clazz);
            s.append(clazz.getSimpleName());
            s.append('|');
            ++n2;
        }
        s.deleteCharAt(s.length() - 1);
        s.append(')');
        Pattern searchPattern = Pattern.compile(s.toString());
        List<Node> nodes = doc.getScriptNodes();
        for (Node node : nodes) {
            Matcher m = searchPattern.matcher(node.getValue());
            while (m.find()) {
                String found = m.group(1).trim();
                Class foundClass = (Class)classNames.get(found);
                if (foundClass == null || !doc.addPageImportDirective(foundClass)) continue;
                this.message(node, "Added page import for " + foundClass + ".");
            }
        }
    }

    private void addUseActionBeanTag(JspDocument doc, Class<? extends ActionBean> beanClass, String event) {
        List<Node> nodes = doc.getNodes();
        for (Node node : nodes) {
            if (!"stripes:useActionBean".equals(node.getName())) continue;
            return;
        }
        Tag tag = new Tag(doc, NodeType.EMPTY_ELEMENT_TAG);
        tag.setName("stripes:useActionBean");
        tag.addAttribute(new Attribute(doc, "beanclass", beanClass.getName()));
        if (event != null) {
            tag.addAttribute(new Attribute(doc, "event", event));
        }
        tag.addAttribute(new Attribute(doc, "id", "wikiActionBean"));
        Text linebreak = new Text(doc);
        linebreak.setValue(System.getProperty("line.separator"));
        AbstractNode root = doc.getRoot();
        linebreak.setParent(root);
        List<Node> directives = doc.getNodes(NodeType.JSP_DIRECTIVE);
        if (directives.size() == 0) {
            root.addChild(linebreak, 0);
            root.addChild(tag, 0);
        } else {
            Node lastDirective = directives.get(directives.size() - 1);
            lastDirective.addSibling(tag);
            lastDirective.addSibling(linebreak);
        }
        this.message(doc.getRoot(), "Added <stripes:useActionBean beanclass=\"" + beanClass.getName() + "\" event=\"" + event + "\" />");
    }

    private void removeSetBundle(Tag tag) {
        Node parent = tag.getParent();
        parent.removeChild(tag);
        this.message(tag, "Removed <fmt:setBundle> tag because it is automatically set in web.xml.");
    }

    private void processFormTag(Tag tag) {
        Attribute attribute = tag.getAttribute("accept-charset");
        if (attribute == null) {
            attribute = tag.getAttribute("acceptcharset");
        }
        if (attribute != null) {
            this.message(attribute, "Changed value to \"UTF-8\".");
            attribute.setValue("UTF-8");
        }
        if ((attribute = tag.getAttribute("onsubmit")) != null) {
            String value = attribute.getValue();
            this.message(attribute, "Removed JavaScript call \"" + value + "\". REASON: it probably does not work with Stripes.");
            tag.removeAttribute(attribute);
        }
    }

    private Map<String, HandlerInfo> cacheRequestContexts(Set<Class<? extends ActionBean>> beanClasses) {
        HashMap<String, String> fields = new HashMap<String, String>();
        Field[] fieldArray = WikiContext.class.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (String.class.equals(field.getType())) {
                String fieldName = field.getName();
                String fieldValue = null;
                try {
                    fieldValue = (String)field.get(null);
                    fields.put(fieldValue, fieldName);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
        HashMap<String, HandlerInfo> contextMap = new HashMap<String, HandlerInfo>();
        for (Class<? extends ActionBean> beanClass : beanClasses) {
            Collection<HandlerInfo> handlers = HandlerInfo.getHandlerInfoCollection(beanClass).values();
            for (HandlerInfo handler : handlers) {
                String eventName = handler.getRequestContext();
                String fieldName = (String)fields.get(eventName);
                if (fieldName == null) continue;
                contextMap.put(fieldName, handler);
            }
        }
        return contextMap;
    }
}

