/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.ui.migrator;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.wiki.util.CommentedProperties;

public class BundleMigrator {
    private Bundle m_source;

    public void copy(String key, Bundle target) throws IOException {
        String value = this.m_source.getProperties(null).getProperty(key);
        if (value == null) {
            throw new IllegalArgumentException("Key " + key + " not found in bundle.");
        }
        this.m_source.load();
        target.load();
        String msg = "Copied from " + this.m_source.m_baseFile.getPath() + ".";
        CommentedProperties props = target.getProperties(null);
        String comment = props.getComment(key);
        comment = comment == null ? msg : String.valueOf(comment) + ". " + msg;
        props.setProperty(key, value, comment);
        Collection<Locale> locales = this.m_source.getLocales();
        for (Locale locale : locales) {
            props = this.m_source.getProperties(locale);
            value = props.getProperty(key);
            if (value == null || (props = target.getProperties(locale)) == null) continue;
            comment = props.getComment(key);
            comment = comment == null ? msg : String.valueOf(comment) + ". " + msg;
            props.setProperty(key, value, comment);
        }
        target.save();
    }

    public Bundle getSource() {
        return this.m_source;
    }

    public void move(String key, Bundle target) throws IOException {
        this.copy(key, target);
        this.remove(key);
    }

    public void remove(String key) throws IOException {
        String value = this.m_source.getProperties(null).getProperty(key);
        if (value == null) {
            throw new IllegalArgumentException("Key " + key + " not found in bundle.");
        }
        this.m_source.load();
        CommentedProperties props = this.m_source.getProperties(null);
        props.remove(key);
        Collection<Locale> locales = this.m_source.getLocales();
        for (Locale locale : locales) {
            props = this.m_source.getProperties(locale);
            value = props.getProperty(key);
            if (value == null) continue;
            props.remove(key);
        }
        this.m_source.save();
    }

    public void rename(String key, String newKey) throws IOException {
        String value = this.m_source.getProperties(null).getProperty(key);
        if (value == null) {
            throw new IllegalArgumentException("Key " + key + " not found in bundle.");
        }
        if (newKey == null) {
            throw new IllegalArgumentException("New key name must not be null.");
        }
        this.m_source.load();
        String msg = "Formerly named " + key + ".";
        CommentedProperties props = this.m_source.getProperties(null);
        String comment = props.getComment(key);
        comment = comment == null ? msg : String.valueOf(comment) + ". " + msg;
        props.remove(key);
        props.setProperty(newKey, value, comment);
        Collection<Locale> locales = this.m_source.getLocales();
        for (Locale locale : locales) {
            props = this.m_source.getProperties(locale);
            value = props.getProperty(key);
            if (value == null) continue;
            comment = props.getComment(key);
            comment = comment == null ? msg : String.valueOf(comment) + ". " + msg;
            props.remove(key);
            props.setProperty(newKey, value, comment);
        }
        this.m_source.save();
    }

    public void setBundle(Bundle source) throws FileNotFoundException, IOException {
        this.m_source = source;
        source.load();
    }

    public static final void main(String[] args) {
        String validSyntax = "BundleMigrator action source keyname [newkeyname | destination]";
        if (args.length == 0) {
            System.err.println("Too few arguments. Valid syntax: " + validSyntax);
            System.err.println("Valid actions are: copy, delete, move, and rename.");
            return;
        }
        try {
            String action = args[0].trim();
            Bundle source = new Bundle(args[1].trim());
            String key = args[2].trim();
            BundleMigrator migrator = new BundleMigrator();
            migrator.setBundle(source);
            if ("delete".equals(action)) {
                if (BundleMigrator.wrongNumberArgs(3, args, "BundleMigrator delete source keyname")) {
                    return;
                }
                migrator.remove(key);
            } else if ("rename".equals(action)) {
                if (BundleMigrator.wrongNumberArgs(4, args, "BundleMigrator rename source keyname newkeyname")) {
                    return;
                }
                String newKey = args[3].trim();
                migrator.rename(key, newKey);
            } else if ("copy".equals(action)) {
                if (BundleMigrator.wrongNumberArgs(4, args, "BundleMigrator copy source keyname destination")) {
                    return;
                }
                Bundle destination = new Bundle(args[3].trim());
                migrator.copy(key, destination);
            } else if ("move".equals(action)) {
                if (BundleMigrator.wrongNumberArgs(4, args, "BundleMigrator move source keyname destination")) {
                    return;
                }
                Bundle destination = new Bundle(args[3].trim());
                migrator.move(key, destination);
            } else {
                System.err.println("Invalid syntax. Valid syntax is: " + validSyntax);
            }
        }
        catch (IOException e) {
            System.err.println("Error: " + e.getMessage());
        }
    }

    private static boolean wrongNumberArgs(int requiredArgs, String[] args, String validSyntax) {
        if (args.length != requiredArgs) {
            System.out.println("Wrong number of arguments. Valid syntax: " + validSyntax);
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Bundle {
        private final Map<Locale, File> m_bundleFiles = new HashMap<Locale, File>();
        private final Map<Locale, CommentedProperties> m_bundleProps = new HashMap<Locale, CommentedProperties>();
        private final File m_baseFile;
        private CommentedProperties m_baseProps;

        public Bundle(String baseFile) throws FileNotFoundException {
            this.m_baseFile = new File(String.valueOf(baseFile) + ".properties");
            this.m_baseProps = new CommentedProperties();
            this.findBundleFiles(baseFile);
        }

        public File getFile(Locale locale) {
            return locale == null ? this.m_baseFile : this.m_bundleFiles.get(locale);
        }

        public Collection<Locale> getLocales() {
            return Collections.unmodifiableSet(this.m_bundleFiles.keySet());
        }

        public CommentedProperties getProperties(Locale locale) {
            return locale == null ? this.m_baseProps : this.m_bundleProps.get(locale);
        }

        public void load() throws IOException {
            this.m_baseProps.load(new FileInputStream(this.m_baseFile));
            for (Map.Entry<Locale, File> entry : this.m_bundleFiles.entrySet()) {
                CommentedProperties props = new CommentedProperties();
                props.load(new FileInputStream(entry.getValue()));
                this.m_bundleProps.put(entry.getKey(), props);
            }
        }

        public void save() throws IOException {
            this.m_baseProps.store(new FileOutputStream(this.m_baseFile), null);
            for (Map.Entry<Locale, File> entry : this.m_bundleFiles.entrySet()) {
                CommentedProperties props = this.m_bundleProps.get(entry.getKey());
                props.store(new FileOutputStream(entry.getValue()), null);
            }
        }

        protected void findBundleFiles(String baseFile) throws FileNotFoundException {
            Locale[] locales;
            File baseBundle = new File(String.valueOf(baseFile) + ".properties");
            if (!baseBundle.exists()) {
                throw new FileNotFoundException("Bundle file " + baseBundle.toString() + " not found.");
            }
            Locale[] localeArray = locales = Locale.getAvailableLocales();
            int n = locales.length;
            int n2 = 0;
            while (n2 < n) {
                Locale locale = localeArray[n2];
                File file = new File(String.valueOf(baseFile) + "_" + locale.toString() + ".properties");
                if (file.exists()) {
                    this.m_bundleFiles.put(locale, file);
                    this.m_bundleProps.put(locale, new CommentedProperties());
                }
                ++n2;
            }
        }
    }
}

