/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.ui.migrator;

import org.apache.wiki.ui.migrator.AbstractNode;
import org.apache.wiki.ui.migrator.JspDocument;
import org.apache.wiki.ui.migrator.Node;
import org.apache.wiki.ui.migrator.NodeType;

public class Attribute
extends AbstractNode {
    private char m_quote = (char)34;

    public Attribute(JspDocument doc) {
        super(doc, NodeType.ATTRIBUTE);
    }

    public Attribute(JspDocument doc, String name, String value) {
        super(doc, NodeType.ATTRIBUTE);
        this.setName(name);
        this.setValue(value);
    }

    public char getAttributeDelimiter() {
        return this.m_quote;
    }

    public void setAttributeDelimiter(char quote) {
        this.m_quote = quote;
    }

    public void setType(NodeType type) {
        if (type != NodeType.ATTRIBUTE && type != NodeType.DYNAMIC_ATTRIBUTE) {
            throw new UnsupportedOperationException("Attributes are always of type NodeType.ATTRIBUTE or NodeType.DYNAMIC_ATTRIBUTE.");
        }
        super.setType(type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.m_type == NodeType.ATTRIBUTE) {
            sb.append(this.m_name);
            sb.append('=');
            sb.append(this.m_quote);
            for (Node valueNode : this.m_children) {
                sb.append(valueNode.toString());
            }
            sb.append(this.m_quote);
        } else {
            sb.append(this.getValue());
        }
        return sb.toString();
    }
}

