/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.ui.migrator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.wiki.ui.migrator.JspDocument;
import org.apache.wiki.ui.migrator.Node;
import org.apache.wiki.ui.migrator.NodeType;
import org.apache.wiki.ui.migrator.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNode
implements Node {
    protected NodeType m_type;
    protected int m_start = -1;
    protected int m_end = -1;
    protected int m_line = -1;
    protected int m_col = -1;
    protected Node m_parent = null;
    protected String m_name = null;
    protected JspDocument m_doc = null;
    protected List<Node> m_children = new ArrayList<Node>();

    AbstractNode(JspDocument doc, NodeType type) {
        this.m_doc = doc;
        this.m_type = type;
    }

    @Override
    public void addChild(Node node) {
        node.setParent(this);
        this.m_children.add(node);
    }

    @Override
    public void addChild(Node node, int index) {
        node.setParent(this);
        this.m_children.add(index, node);
    }

    @Override
    public void addSibling(Node node) {
        if (this.m_parent == null) {
            throw new IllegalStateException("This node does not have a parent.");
        }
        List<Node> siblings = this.m_parent.getChildren();
        int pos = siblings.indexOf(this);
        if (pos == siblings.size() - 1) {
            this.m_parent.addChild(node);
        } else {
            this.m_parent.addChild(node, pos + 1);
        }
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> nodesCopy = new ArrayList<Node>();
        nodesCopy.addAll(this.m_children);
        return Collections.unmodifiableList(nodesCopy);
    }

    @Override
    public int getColumn() {
        return this.m_col;
    }

    @Override
    public int getEnd() {
        return this.m_end;
    }

    @Override
    public JspDocument getJspDocument() {
        return this.m_doc;
    }

    @Override
    public int getLine() {
        return this.m_line;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public Node getParent() {
        return this.m_parent;
    }

    @Override
    public List<Node> getSiblings() {
        ArrayList<Node> siblings = new ArrayList<Node>();
        for (Node sibling : this.m_parent.getChildren()) {
            if (this.equals(sibling)) continue;
            siblings.add(sibling);
        }
        return Collections.unmodifiableList(siblings);
    }

    @Override
    public int getStart() {
        return this.m_start;
    }

    @Override
    public NodeType getType() {
        return this.m_type;
    }

    @Override
    public String getValue() {
        StringBuilder builder = new StringBuilder();
        for (Node child : this.m_children) {
            builder.append(child.toString());
        }
        return builder.toString();
    }

    @Override
    public boolean isHtmlNode() {
        return this.m_type == NodeType.START_TAG || this.m_type == NodeType.EMPTY_ELEMENT_TAG || this.m_type == NodeType.UNRESOLVED_TAG || this.m_type == NodeType.END_TAG || this.m_type == NodeType.DECLARATION || this.m_type == NodeType.LINK || this.m_type == NodeType.META;
    }

    @Override
    public boolean isJspNode() {
        return this.m_type == NodeType.JSP_COMMENT || this.m_type == NodeType.JSP_DECLARATION || this.m_type == NodeType.JSP_EXPRESSION || this.m_type == NodeType.SCRIPTLET || this.m_type == NodeType.JSP_DIRECTIVE;
    }

    public boolean isTagWithAttributes() {
        return this.m_type == NodeType.START_TAG || this.m_type == NodeType.EMPTY_ELEMENT_TAG || this.m_type == NodeType.UNRESOLVED_TAG;
    }

    @Override
    public void removeChild(Node node) {
        this.m_children.remove(node);
    }

    @Override
    public void setColumn(int i) {
        this.m_col = i;
    }

    @Override
    public void setEnd(int pos) {
        this.m_end = pos;
    }

    @Override
    public void setLine(int i) {
        this.m_line = i;
    }

    @Override
    public void setName(String name) {
        this.m_name = name;
    }

    @Override
    public void setParent(Node parent) {
        this.m_parent = parent;
    }

    @Override
    public void setStart(int pos) {
        this.m_start = pos;
    }

    @Override
    public void setType(NodeType type) {
        this.m_type = type;
    }

    @Override
    public void setValue(String value) {
        this.m_children.clear();
        Text node = new Text(this.m_doc);
        node.setValue(value);
        this.m_children.add(node);
    }
}

