/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.ui.admin.beans;

import java.util.Collection;
import java.util.Iterator;
import javax.management.NotCompliantMBeanException;
import org.apache.ecs.Element;
import org.apache.ecs.xhtml.div;
import org.apache.ecs.xhtml.h4;
import org.apache.ecs.xhtml.table;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.th;
import org.apache.ecs.xhtml.tr;
import org.apache.wiki.Release;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.plugin.PluginManager;
import org.apache.wiki.ui.admin.SimpleAdminBean;

public class PluginBean
extends SimpleAdminBean {
    private WikiEngine m_engine;

    public PluginBean(WikiEngine engine) throws NotCompliantMBeanException {
        this.m_engine = engine;
    }

    public String[] getAttributeNames() {
        return new String[0];
    }

    public String[] getMethodNames() {
        return new String[0];
    }

    public String getTitle() {
        return "Plugins";
    }

    public int getType() {
        return 1;
    }

    public String doGet(WikiContext context) {
        Collection<PluginManager.WikiPluginInfo> plugins = this.m_engine.getPluginManager().modules();
        div root = new div();
        root.addElement((Element)new h4("Plugins"));
        table tb = new table().setBorder(1);
        root.addElement((Element)tb);
        tr head = new tr();
        head.addElement((Element)new th("Name"));
        head.addElement((Element)new th("Aliases"));
        head.addElement((Element)new th("Author"));
        head.addElement((Element)new th("Notes"));
        tb.addElement((Element)head);
        Iterator<PluginManager.WikiPluginInfo> i = plugins.iterator();
        while (i.hasNext()) {
            tr row = new tr();
            tb.addElement((Element)row);
            PluginManager.WikiPluginInfo info = i.next();
            StringBuilder aliases = new StringBuilder();
            String[] stringArray = info.getAliases();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (aliases.length() > 0) {
                    aliases.append(", ");
                }
                aliases.append(s);
                ++n2;
            }
            row.addElement((Element)new td(info.getName()));
            row.addElement((Element)new td(aliases.toString()));
            row.addElement((Element)new td(info.getAuthor()));
            String verWarning = "";
            if (!Release.isNewerOrEqual(info.getMinVersion()) || !Release.isOlderOrEqual(info.getMaxVersion())) {
                verWarning = "<span class='warning'>This module is not compatible with this version of JSPWiki.</span>";
            }
            row.addElement((Element)new td(verWarning));
        }
        return root.toString();
    }
}

