/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.ui.admin;

import java.lang.management.ManagementFactory;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.management.DynamicMBean;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.event.WikiEngineEvent;
import org.apache.wiki.event.WikiEvent;
import org.apache.wiki.event.WikiEventListener;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.apache.wiki.modules.WikiModuleInfo;
import org.apache.wiki.ui.admin.AdminBean;
import org.apache.wiki.ui.admin.beans.CoreBean;
import org.apache.wiki.ui.admin.beans.PluginBean;
import org.apache.wiki.ui.admin.beans.SearchManagerBean;
import org.apache.wiki.ui.admin.beans.UserBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdminBeanManager
implements WikiEventListener {
    private WikiEngine m_engine;
    private ArrayList<AdminBean> m_allBeans;
    private MBeanServer m_mbeanServer = ManagementFactory.getPlatformMBeanServer();
    private static final Logger log = LoggerFactory.getLogger(AdminBeanManager.class);

    public AdminBeanManager(WikiEngine engine) {
        this.m_engine = engine;
        if (this.m_mbeanServer != null) {
            log.info(this.m_mbeanServer.getClass().getName(), new Object[0]);
            log.info(this.m_mbeanServer.getDefaultDomain(), new Object[0]);
        }
        this.m_engine.addWikiEventListener(this);
        this.initialize();
    }

    public void initialize() {
        this.reload();
    }

    private String getJMXTitleString(int title) {
        switch (title) {
            case 1: {
                return "Core";
            }
            case 2: {
                return "Editors";
            }
        }
        return "Unknown";
    }

    private void registerAdminBean(AdminBean ab) {
        try {
            if (ab instanceof DynamicMBean && this.m_mbeanServer != null) {
                ObjectName name = this.getObjectName(ab);
                if (!this.m_mbeanServer.isRegistered(name)) {
                    this.m_mbeanServer.registerMBean(ab, name);
                    log.info("Registered new admin bean " + ab.getTitle(), new Object[0]);
                } else {
                    log.error("JMX bean named " + name + " is already registered. Hint: are you running 2 webapps with the same " + "jspwiki.applicationName" + "?", new Object[0]);
                }
            }
            this.m_allBeans.add(ab);
        }
        catch (InstanceAlreadyExistsException e) {
            log.error("Admin bean already registered to JMX", e);
        }
        catch (MBeanRegistrationException e) {
            log.error("Admin bean cannot be registered to JMX", e);
        }
        catch (NotCompliantMBeanException e) {
            log.error("Your admin bean is not very good", e);
        }
        catch (MalformedObjectNameException e) {
            log.error("Your admin bean name is not very good", e);
        }
        catch (NullPointerException e) {
            log.error("Evil NPE occurred", e);
        }
        catch (AccessControlException e) {
            log.error("Evil AccessControlException occurred", e);
        }
    }

    private ObjectName getObjectName(AdminBean ab) throws MalformedObjectNameException {
        String component = this.getJMXTitleString(ab.getType());
        String title = ab.getTitle();
        ObjectName name = new ObjectName("JSPWiki:wiki=" + this.m_engine.getApplicationName() + ",component=" + component + ",name=" + title);
        return name;
    }

    private void registerBeans(Collection<? extends WikiModuleInfo> modules) {
        for (WikiModuleInfo wikiModuleInfo : modules) {
            String abname = wikiModuleInfo.getAdminBeanClass();
            try {
                if (abname == null || abname.length() <= 0) continue;
                Class<?> abclass = Class.forName(abname);
                AdminBean ab = (AdminBean)abclass.newInstance();
                this.registerAdminBean(ab);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    private void reload() {
        this.m_allBeans = new ArrayList();
        try {
            this.registerAdminBean(new CoreBean(this.m_engine));
            this.registerAdminBean(new UserBean(this.m_engine));
            this.registerAdminBean(new SearchManagerBean(this.m_engine));
            this.registerAdminBean(new PluginBean(this.m_engine));
        }
        catch (NotCompliantMBeanException e) {
            e.printStackTrace();
        }
        this.registerBeans(this.m_engine.getEditorManager().modules());
        this.registerBeans(this.m_engine.getPluginManager().modules());
    }

    public List<AdminBean> getAllBeans() {
        if (this.m_allBeans == null) {
            this.reload();
        }
        return this.m_allBeans;
    }

    public AdminBean findBean(String id) {
        for (AdminBean ab : this.m_allBeans) {
            if (!ab.getId().equals(id)) continue;
            return ab;
        }
        return null;
    }

    public static int getTypeFromString(String type) {
        if (type.equals("core")) {
            return 1;
        }
        if (type.equals("editors")) {
            return 2;
        }
        return 0;
    }

    @Override
    public void actionPerformed(WikiEvent event) {
        if (event instanceof WikiEngineEvent && ((WikiEngineEvent)event).getType() == 1) {
            for (AdminBean ab : this.m_allBeans) {
                try {
                    ObjectName on = this.getObjectName(ab);
                    if (!this.m_mbeanServer.isRegistered(on)) continue;
                    this.m_mbeanServer.unregisterMBean(on);
                    log.info("Unregistered AdminBean " + ab.getTitle(), new Object[0]);
                }
                catch (MalformedObjectNameException e) {
                    log.error("Malformed object name when unregistering", e);
                }
                catch (InstanceNotFoundException e) {
                    log.error("Object was registered; yet claims that it's not there", e);
                }
                catch (MBeanRegistrationException e) {
                    log.error("Registration exception while unregistering", e);
                }
            }
        }
    }
}

