/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.ui;

import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.PageContext;
import org.apache.commons.lang.StringUtils;
import org.apache.wiki.InternalWikiException;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.event.WikiEngineEvent;
import org.apache.wiki.event.WikiEvent;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.apache.wiki.modules.ModuleManager;
import org.apache.wiki.modules.WikiModuleInfo;
import org.apache.wiki.preferences.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateManager
extends ModuleManager {
    private static final String SKIN_DIR = "skins";
    private static final String RESOURCE_RESOLVER = "resourceResolver";
    public static final String TEMPLATE_JAVASCRIPT_STRINGS = "templateJsStrings";
    public static final String TEMPLATE_DIR = "templates";
    public static final String DEFAULT_TEMPLATE = "default";
    protected static final Logger log = LoggerFactory.getLogger(TemplateManager.class);
    private WikiEngine m_engine;

    public static Map<String, String> getResourceResolver(ServletContext context) {
        Map<String, String> resolver = (HashMap<String, String>)context.getAttribute(RESOURCE_RESOLVER);
        if (resolver == null) {
            String template = null;
            try {
                WikiEngine engine = WikiEngine.getInstance(context, null);
                template = engine.getTemplateDir();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (template == null) {
                template = DEFAULT_TEMPLATE;
            }
            resolver = new HashMap<String, String>();
            TemplateManager.addResources(context, resolver, "/templates/" + template + "/", null);
            TemplateManager.addResources(context, resolver, "/templates/default/", null);
            resolver = Collections.unmodifiableMap(resolver);
            context.setAttribute(RESOURCE_RESOLVER, resolver);
        }
        return resolver;
    }

    public static String getTemplateJSStrings(HttpSession session, Locale locale) {
        String templateString;
        if (!Preferences.AVAILABLE_LOCALES.containsKey(locale)) {
            return "";
        }
        ServletContext context = session.getServletContext();
        HashMap<Locale, String> templateStrings = (HashMap<Locale, String>)context.getAttribute(TEMPLATE_JAVASCRIPT_STRINGS);
        if (templateStrings == null) {
            templateStrings = new HashMap<Locale, String>();
            context.setAttribute(TEMPLATE_JAVASCRIPT_STRINGS, templateStrings);
        }
        if ((templateString = (String)templateStrings.get(locale)) == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("var LocalizedStrings = {\n");
            ResourceBundle rb = ResourceBundle.getBundle("templates.default", locale);
            boolean first = true;
            Enumeration<String> en = rb.getKeys();
            while (en.hasMoreElements()) {
                String key = en.nextElement();
                if (!key.startsWith("javascript")) continue;
                if (first) {
                    first = false;
                } else {
                    sb.append(",\n");
                }
                sb.append("\"" + key + "\":\"" + rb.getString(key) + "\"");
            }
            sb.append("\n};\n");
            templateString = sb.toString();
            templateStrings.put(locale, templateString);
        }
        return templateString;
    }

    private static void addResources(ServletContext context, Map<String, String> resolver, String prefix, String dir) {
        String searchPath = dir == null ? prefix : String.valueOf(prefix) + dir;
        Set resources = context.getResourcePaths(searchPath);
        if (resources != null) {
            for (String resource : resources) {
                String shortName = resource.substring(prefix.length());
                if (shortName.endsWith("/")) {
                    TemplateManager.addResources(context, resolver, prefix, shortName);
                    continue;
                }
                boolean alreadyProcessed = resolver.containsKey(shortName);
                if (alreadyProcessed) continue;
                resolver.put(shortName, resource);
            }
        }
    }

    private static String findResource(ServletContext servletContext, String path) {
        if (path.charAt(0) == '/') {
            return TemplateManager.findResource(servletContext, path);
        }
        return TemplateManager.getResourceResolver(servletContext).get(path);
    }

    private static final String getPath(String template) {
        return "/templates/" + template + "/";
    }

    public TemplateManager(WikiEngine engine, Properties properties) {
        super(engine);
        this.m_engine = engine;
        TemplateManager.getResourceResolver(engine.getServletContext());
    }

    public void actionPerformed(WikiEvent event) {
        if (event instanceof WikiEngineEvent && event.getType() == 1 && this.m_engine != null) {
            this.m_engine.getServletContext().removeAttribute(RESOURCE_RESOLVER);
            this.m_engine.getServletContext().removeAttribute(TEMPLATE_JAVASCRIPT_STRINGS);
        }
    }

    public String findJSP(PageContext pageContext, String name) {
        ServletContext sContext = pageContext.getServletContext();
        return TemplateManager.findResource(sContext, name);
    }

    public String findJSP(PageContext pageContext, String template, String name) {
        if (name == null || template == null) {
            log.error("findJSP() was asked to find a null template or name (" + template + "," + name + ")." + " JSP page '" + ((HttpServletRequest)pageContext.getRequest()).getRequestURI() + "'", new Object[0]);
            throw new InternalWikiException("Illegal arguments to findJSP(); please check logs.");
        }
        return TemplateManager.findResource(pageContext.getServletContext(), name);
    }

    public String findResource(WikiContext ctx, String template, String name) {
        if (this.m_engine.getServletContext() != null) {
            return TemplateManager.findResource(this.m_engine.getServletContext(), name);
        }
        return String.valueOf(TemplateManager.getPath(template)) + "/" + name;
    }

    public Set<String> listSkins() {
        String skinPath = "/templates/" + this.m_engine.getTemplateDir() + "/" + SKIN_DIR;
        Set skinSet = this.m_engine.getServletContext().getResourcePaths(skinPath);
        TreeSet<String> resultSet = new TreeSet<String>();
        if (log.isDebugEnabled()) {
            log.debug("Listings skins from " + skinPath, new Object[0]);
        }
        if (skinSet != null) {
            String[] skins = new String[]{};
            skins = skinSet.toArray(skins);
            int i = 0;
            while (i < skins.length) {
                String[] s = StringUtils.split((String)skins[i], (String)"/");
                if (s.length > 2 && skins[i].endsWith("/")) {
                    String skinName = s[s.length - 1];
                    resultSet.add(skinName);
                    if (log.isDebugEnabled()) {
                        log.debug("...adding skin '" + skinName + "'", new Object[0]);
                    }
                }
                ++i;
            }
        }
        return resultSet;
    }

    public Collection<WikiModuleInfo> modules() {
        return Collections.emptyList();
    }
}

