/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.ui;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;
import org.apache.wiki.NoSuchVariableException;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.apache.wiki.modules.ModuleManager;
import org.apache.wiki.modules.WikiModuleInfo;
import org.apache.wiki.preferences.Preferences;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.xpath.XPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorManager
extends ModuleManager {
    public static final String PROP_EDITORTYPE = "jspwiki.editor";
    public static final String PARA_EDITOR = "editor";
    public static final String EDITOR_PLAIN = "plain";
    public static final String REQ_EDITEDTEXT = "_editedtext";
    public static final String ATTR_EDITEDTEXT = "_editedtext";
    private Map<String, WikiEditorInfo> m_editors;
    private static Logger log = LoggerFactory.getLogger(EditorManager.class);

    public EditorManager(WikiEngine engine) {
        super(engine);
    }

    public void initialize(Properties props) {
        this.registerEditors();
    }

    private void registerEditors() {
        log.info("Registering editor modules", new Object[0]);
        this.m_editors = new HashMap<String, WikiEditorInfo>();
        SAXBuilder builder = new SAXBuilder();
        try {
            Enumeration<URL> resources = this.getClass().getClassLoader().getResources("ini/jspwiki_module.xml");
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                try {
                    log.debug("Processing XML: " + resource, new Object[0]);
                    Document doc = builder.build(resource);
                    List plugins = XPath.selectNodes((Object)doc, (String)"/modules/editor");
                    for (Element pluginEl : plugins) {
                        String name = pluginEl.getAttributeValue("name");
                        WikiEditorInfo info = WikiEditorInfo.newInstance(name, pluginEl);
                        if (this.checkCompatibility(info)) {
                            this.m_editors.put(name, info);
                            log.debug("Registered editor " + name, new Object[0]);
                            continue;
                        }
                        log.info("Editor '" + name + "' not compatible with this version of JSPWiki.", new Object[0]);
                    }
                }
                catch (IOException e) {
                    log.error("Couldn't load ini/jspwiki_module.xml resources: " + resource, e);
                }
                catch (JDOMException e) {
                    log.error("Error parsing XML for plugin: ini/jspwiki_module.xml", new Object[0]);
                }
            }
        }
        catch (IOException e) {
            log.error("Couldn't load all ini/jspwiki_module.xml resources", e);
        }
    }

    public String getEditorName(WikiContext context) {
        String editor = null;
        Preferences prefs = Preferences.getPreferences(context.getHttpRequest());
        editor = (String)prefs.get("Editor");
        if (editor == null) {
            try {
                editor = this.m_engine.getVariableManager().getValue(context, PROP_EDITORTYPE);
            }
            catch (NoSuchVariableException noSuchVariableException) {
                // empty catch block
            }
        }
        if (editor != null) {
            String[] editorlist = this.getEditorList();
            editor = editor.trim();
            int i = 0;
            while (i < editorlist.length) {
                if (editorlist[i].equalsIgnoreCase(editor)) {
                    return editorlist[i];
                }
                ++i;
            }
        }
        return EDITOR_PLAIN;
    }

    public String[] getEditorList() {
        String[] editors = new String[this.m_editors.size()];
        Set<String> keys = this.m_editors.keySet();
        return keys.toArray(editors);
    }

    public String getEditorPath(WikiContext context) {
        String path = null;
        String editor = this.getEditorName(context);
        WikiEditorInfo ed = this.m_editors.get(editor);
        path = ed != null ? ed.getPath() : "editors/" + editor + ".jsp";
        return path;
    }

    public static String getEditedText(PageContext ctx) {
        String usertext = ctx.getRequest().getParameter("_editedtext");
        if (usertext == null) {
            usertext = (String)ctx.findAttribute("_editedtext");
        }
        return usertext;
    }

    public static String getEditedText(HttpServletRequest request) {
        String usertext = request.getParameter("_editedtext");
        if (usertext == null) {
            usertext = request.getSession().getAttribute("_editedtext").toString();
        }
        return usertext;
    }

    public Collection<WikiModuleInfo> modules() {
        ArrayList<WikiModuleInfo> ls = new ArrayList<WikiModuleInfo>();
        ls.addAll(this.m_editors.values());
        return ls;
    }

    private static final class WikiEditorInfo
    extends WikiModuleInfo {
        private String m_path;

        protected static WikiEditorInfo newInstance(String name, Element el) {
            if (name == null || name.length() == 0) {
                return null;
            }
            WikiEditorInfo info = new WikiEditorInfo(name);
            info.initializeFromXML(el);
            return info;
        }

        protected void initializeFromXML(Element el) {
            super.initializeFromXML(el);
            this.m_path = el.getChildText("path");
        }

        private WikiEditorInfo(String name) {
            super(name);
        }

        public String getPath() {
            return this.m_path;
        }
    }
}

